/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternPackageSet
extends PatternBasedPackageSet {
    @NonNls
    public static final String SCOPE_TEST = "test";
    @NonNls
    public static final String SCOPE_SOURCE = "src";
    @NonNls
    public static final String SCOPE_LIBRARY = "lib";
    @NonNls
    public static final String SCOPE_PROBLEM = "problem";
    public static final String SCOPE_ANY = "";
    private final Pattern myPattern;
    private final Pattern myModulePattern;
    private final Pattern myModuleGroupPattern;
    private final String myAspectJSyntaxPattern;
    private final String myScope;
    private final String myModulePatternText;

    public PatternPackageSet(@NonNls @Nullable String aspectPattern, @NotNull String scope, @NonNls String modulePattern) {
        if (scope == null) {
            PatternPackageSet.$$$reportNull$$$0(0);
        }
        this.myAspectJSyntaxPattern = aspectPattern;
        this.myScope = scope;
        this.myModulePatternText = modulePattern;
        Pattern mmgp = null;
        Pattern mmp = null;
        if (modulePattern == null || modulePattern.isEmpty()) {
            mmp = null;
        } else if (modulePattern.startsWith("group:")) {
            int idx = modulePattern.indexOf(58, 6);
            if (idx == -1) {
                idx = modulePattern.length();
            }
            mmgp = Pattern.compile(StringUtil.replace(modulePattern.substring(6, idx), "*", ".*"));
            if (idx < modulePattern.length() - 1) {
                mmp = Pattern.compile(StringUtil.replace(modulePattern.substring(idx + 1), "*", ".*"));
            }
        } else {
            mmp = Pattern.compile(StringUtil.replace(modulePattern, "*", ".*"));
        }
        this.myModulePattern = mmp;
        this.myModuleGroupPattern = mmgp;
        this.myPattern = aspectPattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(aspectPattern, '.')) : null;
    }

    @Override
    public boolean contains(VirtualFile file2, @NotNull NamedScopesHolder holder) {
        if (holder == null) {
            PatternPackageSet.$$$reportNull$$$0(1);
        }
        return this.contains(file2, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file2, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        ProjectFileIndex fileIndex;
        if (project == null) {
            PatternPackageSet.$$$reportNull$$$0(2);
        }
        if (this.matchesScope(file2, project, fileIndex = ProjectRootManager.getInstance(project).getFileIndex())) {
            if (this.myPattern == null) {
                return true;
            }
            String packageName = PatternPackageSet.getPackageName(file2, fileIndex);
            if (packageName != null && this.myPattern.matcher(packageName).matches()) {
                return true;
            }
        }
        return false;
    }

    private boolean matchesScope(VirtualFile file2, Project project, ProjectFileIndex fileIndex) {
        if (file2 == null) {
            return false;
        }
        boolean isSource = fileIndex.isInSourceContent(file2);
        if (this.myScope == SCOPE_ANY) {
            return fileIndex.isInContent(file2) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file2, fileIndex);
        }
        if (this.myScope == SCOPE_SOURCE) {
            return isSource && !TestSourcesFilter.isTestSources(file2, project) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file2, fileIndex);
        }
        if (this.myScope == SCOPE_LIBRARY) {
            return (fileIndex.isInLibraryClasses(file2) || fileIndex.isInLibrarySource(file2)) && PatternPackageSet.matchesLibrary(this.myModulePattern, file2, fileIndex);
        }
        if (this.myScope == SCOPE_TEST) {
            return isSource && TestSourcesFilter.isTestSources(file2, project) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file2, fileIndex);
        }
        if (this.myScope == SCOPE_PROBLEM) {
            return isSource && WolfTheProblemSolver.getInstance(project).isProblemFile(file2) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file2, fileIndex);
        }
        throw new RuntimeException("Unknown scope: " + this.myScope);
    }

    private static String getPackageName(VirtualFile file2, ProjectFileIndex fileIndex) {
        VirtualFile dir;
        VirtualFile virtualFile2 = dir = file2.isDirectory() ? file2 : file2.getParent();
        if (dir == null) {
            return null;
        }
        return StringUtil.getQualifiedName(fileIndex.getPackageNameByDirectory(dir), file2.getNameWithoutExtension());
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        PatternPackageSet patternPackageSet = new PatternPackageSet(this.myAspectJSyntaxPattern, this.myScope, this.myModulePatternText);
        if (patternPackageSet == null) {
            PatternPackageSet.$$$reportNull$$$0(3);
        }
        return patternPackageSet;
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    @NotNull
    public String getText() {
        StringBuilder buf = new StringBuilder();
        if (this.myScope != SCOPE_ANY) {
            buf.append(this.myScope);
        }
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myAspectJSyntaxPattern);
        String string = buf.toString();
        if (string == null) {
            PatternPackageSet.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public String getModulePattern() {
        return this.myModulePatternText;
    }

    @Override
    public boolean isOn(String oldQName) {
        return Comparing.strEqual(oldQName, this.myAspectJSyntaxPattern) || Comparing.strEqual(oldQName + "..*", this.myAspectJSyntaxPattern) || Comparing.strEqual(oldQName + ".*", this.myAspectJSyntaxPattern);
    }

    @Override
    public String getPattern() {
        return this.myAspectJSyntaxPattern;
    }

    public static boolean matchesLibrary(Pattern libPattern, VirtualFile file2, ProjectFileIndex fileIndex) {
        if (libPattern != null) {
            List<OrderEntry> entries2 = fileIndex.getOrderEntriesForFile(file2);
            for (OrderEntry orderEntry : entries2) {
                String jdkName;
                String presentableName2;
                String fileName;
                String libraryName;
                if (!(orderEntry instanceof LibraryOrderEntry ? ((libraryName = ((LibraryOrderEntry)orderEntry).getLibraryName()) != null ? libPattern.matcher(libraryName).matches() : libPattern.matcher(fileName = new File(presentableName2 = orderEntry.getPresentableName()).getName()).matches()) : orderEntry instanceof JdkOrderEntry && (jdkName = ((JdkOrderEntry)orderEntry).getJdkName()) != null && libPattern.matcher(jdkName).matches())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/PatternPackageSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/PatternPackageSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

