/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.Query;
import com.intellij.util.QueryFactory;
import org.jetbrains.annotations.NotNull;

public abstract class IndexPatternSearch
extends QueryFactory<IndexPatternOccurrence, SearchParameters> {
    protected IndexPatternSearch() {
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file2, @NotNull IndexPattern pattern) {
        if (file2 == null) {
            IndexPatternSearch.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            IndexPatternSearch.$$$reportNull$$$0(1);
        }
        SearchParameters parameters2 = new SearchParameters(file2, pattern);
        Query<IndexPatternOccurrence> query = Holder.INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters2);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(2);
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file2, @NotNull IndexPattern pattern, int startOffset, int endOffset) {
        if (file2 == null) {
            IndexPatternSearch.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            IndexPatternSearch.$$$reportNull$$$0(4);
        }
        SearchParameters parameters2 = new SearchParameters(file2, pattern, new TextRange(startOffset, endOffset));
        Query<IndexPatternOccurrence> query = Holder.INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters2);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(5);
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file2, @NotNull IndexPatternProvider patternProvider) {
        if (file2 == null) {
            IndexPatternSearch.$$$reportNull$$$0(6);
        }
        if (patternProvider == null) {
            IndexPatternSearch.$$$reportNull$$$0(7);
        }
        SearchParameters parameters2 = new SearchParameters(file2, patternProvider);
        Query<IndexPatternOccurrence> query = Holder.INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters2);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(8);
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file2, @NotNull IndexPatternProvider patternProvider, int startOffset, int endOffset) {
        if (file2 == null) {
            IndexPatternSearch.$$$reportNull$$$0(9);
        }
        if (patternProvider == null) {
            IndexPatternSearch.$$$reportNull$$$0(10);
        }
        SearchParameters parameters2 = new SearchParameters(file2, patternProvider, new TextRange(startOffset, endOffset));
        Query<IndexPatternOccurrence> query = Holder.INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters2);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(11);
        }
        return query;
    }

    public static int getOccurrencesCount(@NotNull PsiFile file2, @NotNull IndexPatternProvider patternProvider) {
        if (file2 == null) {
            IndexPatternSearch.$$$reportNull$$$0(12);
        }
        if (patternProvider == null) {
            IndexPatternSearch.$$$reportNull$$$0(13);
        }
        return Holder.INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file2, patternProvider);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file2, @NotNull IndexPattern pattern) {
        if (file2 == null) {
            IndexPatternSearch.$$$reportNull$$$0(14);
        }
        if (pattern == null) {
            IndexPatternSearch.$$$reportNull$$$0(15);
        }
        return Holder.INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file2, pattern);
    }

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPatternProvider var2);

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPattern var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/IndexPatternSearch";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/IndexPatternSearch";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrencesCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SearchParameters {
        private final PsiFile myFile;
        private final IndexPattern myPattern;
        private final IndexPatternProvider myPatternProvider;
        private final TextRange myRange;

        public SearchParameters(@NotNull PsiFile file2, @NotNull IndexPattern pattern) {
            if (file2 == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this(file2, pattern, null);
        }

        public SearchParameters(@NotNull PsiFile file2, @NotNull IndexPattern pattern, TextRange range) {
            if (file2 == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            if (pattern == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            this.myFile = file2;
            this.myRange = range;
            this.myPatternProvider = null;
            this.myPattern = pattern;
        }

        public SearchParameters(@NotNull PsiFile file2, @NotNull IndexPatternProvider patternProvider) {
            if (file2 == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            if (patternProvider == null) {
                SearchParameters.$$$reportNull$$$0(5);
            }
            this(file2, patternProvider, null);
        }

        public SearchParameters(@NotNull PsiFile file2, @NotNull IndexPatternProvider patternProvider, TextRange range) {
            if (file2 == null) {
                SearchParameters.$$$reportNull$$$0(6);
            }
            if (patternProvider == null) {
                SearchParameters.$$$reportNull$$$0(7);
            }
            this.myFile = file2;
            this.myPatternProvider = patternProvider;
            this.myRange = range;
            this.myPattern = null;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                SearchParameters.$$$reportNull$$$0(8);
            }
            return psiFile;
        }

        public IndexPattern getPattern() {
            return this.myPattern;
        }

        public IndexPatternProvider getPatternProvider() {
            return this.myPatternProvider;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternProvider";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Holder {
        private static final IndexPatternSearch INDEX_PATTERN_SEARCH_INSTANCE = ServiceManager.getService(IndexPatternSearch.class);

        private Holder() {
        }
    }
}

