/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.StubFileElementType;
import java.util.ArrayList;
import java.util.List;

public abstract class SerializationManager {
    protected final List<ObjectStubSerializer> myAllSerializers = new ArrayList<ObjectStubSerializer>();
    private volatile boolean mySerializersLoaded;

    public static SerializationManager getInstance() {
        return ApplicationManager.getApplication().getComponent(SerializationManager.class);
    }

    public void registerSerializer(ObjectStubSerializer serializer2) {
        this.myAllSerializers.add(serializer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSerializers() {
        if (this.mySerializersLoaded) {
            return;
        }
        SerializationManager serializationManager = this;
        synchronized (serializationManager) {
            IElementType[] stubElementTypes;
            if (this.mySerializersLoaded) {
                return;
            }
            IStubElementType.loadRegisteredStubElementTypes();
            for (IElementType type3 : stubElementTypes = IElementType.enumerate(type2 -> type2 instanceof StubSerializer)) {
                StubSerializer stubSerializer;
                if (type3 instanceof StubFileElementType && "psi.file".equals(((StubFileElementType)type3).getExternalId()) || this.myAllSerializers.contains(stubSerializer = (StubSerializer)((Object)type3))) continue;
                this.registerSerializer(stubSerializer);
            }
            this.mySerializersLoaded = true;
        }
    }

    public abstract String internString(String var1);
}

