/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaSimplePropertyIndexKt;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyUtil
extends PropertyUtilBase {
    private PropertyUtil() {
    }

    @Nullable
    public static PsiField getFieldOfGetter(PsiMethod method) {
        return PropertyUtil.getFieldOfGetter(method, true);
    }

    @Nullable
    private static PsiField getFieldOfGetter(PsiMethod method, boolean useIndex) {
        PsiField field;
        PsiField psiField = field = useIndex && method instanceof PsiMethodImpl && method.isPhysical() ? JavaSimplePropertyIndexKt.getFieldOfGetter((PsiMethodImpl)method) : PropertyUtil.getSimplyReturnedField(PropertyUtil.getGetterReturnExpression(method));
        if (field == null || !PropertyUtil.checkFieldLocation(method, field)) {
            return null;
        }
        PsiType returnType = method.getReturnType();
        return returnType != null && field.getType().equals(returnType) ? field : null;
    }

    @Nullable
    public static PsiField getSimplyReturnedField(@Nullable PsiExpression value) {
        if (!(value instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)value;
        if (PropertyUtil.hasSubstantialQualifier(reference)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (!(referent instanceof PsiField)) {
            return null;
        }
        return (PsiField)referent;
    }

    private static boolean hasSubstantialQualifier(PsiReferenceExpression reference) {
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            return false;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            return !(((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass);
        }
        return true;
    }

    public static boolean isSimpleGetter(PsiMethod method) {
        return PropertyUtil.isSimpleGetter(method, true);
    }

    public static boolean isSimpleGetter(PsiMethod method, boolean useIndex) {
        return PropertyUtil.getFieldOfGetter(method, useIndex) != null;
    }

    @Nullable
    public static PsiField getFieldOfSetter(@Nullable PsiMethod method) {
        return PropertyUtil.getFieldOfSetter(method, true);
    }

    @Nullable
    private static PsiField getFieldOfSetter(@Nullable PsiMethod method, boolean useIndex) {
        PsiField field;
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return null;
        }
        if (useIndex && method instanceof PsiMethodImpl && method.isPhysical()) {
            field = JavaSimplePropertyIndexKt.getFieldOfSetter((PsiMethodImpl)method);
        } else {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            String name = method.getName();
            if (!name.startsWith("set")) {
                return null;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return null;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return null;
            }
            PsiStatement statement2 = statements[0];
            if (!(statement2 instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement possibleAssignmentStatement = (PsiExpressionStatement)statement2;
            PsiExpression possibleAssignment = possibleAssignmentStatement.getExpression();
            if (!(possibleAssignment instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)possibleAssignment;
            if (!JavaTokenType.EQ.equals(assignment.getOperationTokenType())) {
                return null;
            }
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier instanceof PsiReferenceExpression ? !((target = (referenceExpression = (PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass) : qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return null;
            }
            PsiElement referent = reference.resolve();
            if (referent == null) {
                return null;
            }
            if (!(referent instanceof PsiField)) {
                return null;
            }
            field = (PsiField)referent;
            PsiExpression rhs = assignment.getRExpression();
            if (!(rhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression rReference = (PsiReferenceExpression)rhs;
            PsiExpression rQualifier = rReference.getQualifierExpression();
            if (rQualifier != null) {
                return null;
            }
            PsiElement rReferent = rReference.resolve();
            if (rReferent == null) {
                return null;
            }
            if (!(rReferent instanceof PsiParameter)) {
                return null;
            }
        }
        return field != null && field.getType().equals(parameterList.getParameters()[0].getType()) && PropertyUtil.checkFieldLocation(method, field) ? field : null;
    }

    public static boolean isSimpleSetter(PsiMethod method) {
        return PropertyUtil.isSimpleSetter(method, true);
    }

    public static boolean isSimpleSetter(PsiMethod method, boolean useIndex) {
        return PropertyUtil.getFieldOfSetter(method, useIndex) != null;
    }

    @Nullable
    public static PsiMethod getReversePropertyMethod(PsiMethod propertyMethod) {
        PsiField field;
        String prefix;
        if (propertyMethod == null) {
            return null;
        }
        PsiClass aClass2 = propertyMethod.getContainingClass();
        if (aClass2 == null) {
            return null;
        }
        String methodName = propertyMethod.getName();
        if (methodName.startsWith("get")) {
            prefix = "get";
        } else if (methodName.startsWith("is")) {
            prefix = "is";
        } else if (methodName.startsWith("set")) {
            prefix = "set";
        } else {
            return null;
        }
        String name = methodName.substring(prefix.length());
        PsiField psiField = field = prefix.equals("set") ? PropertyUtil.getFieldOfSetter(propertyMethod) : PropertyUtil.getFieldOfGetter(propertyMethod);
        if (field == null) {
            return null;
        }
        if (prefix.equals("set")) {
            PsiMethod result2 = PropertyUtil.findPropertyMethod(aClass2, "get", name, field);
            if (result2 != null) {
                return result2;
            }
            return PropertyUtil.findPropertyMethod(aClass2, "is", name, field);
        }
        return PropertyUtil.findPropertyMethod(aClass2, "set", name, field);
    }

    private static PsiMethod findPropertyMethod(@NotNull PsiClass aClass2, @NotNull String prefix, @NotNull String propertyName, @NotNull PsiField field1) {
        PsiMethod[] methods2;
        if (aClass2 == null) {
            PropertyUtil.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            PropertyUtil.$$$reportNull$$$0(1);
        }
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(2);
        }
        if (field1 == null) {
            PropertyUtil.$$$reportNull$$$0(3);
        }
        for (PsiMethod method : methods2 = aClass2.findMethodsByName(prefix + propertyName, true)) {
            PsiField field2;
            PsiField psiField = field2 = prefix.equals("set") ? PropertyUtil.getFieldOfSetter(method) : PropertyUtil.getFieldOfGetter(method);
            if (!field1.equals(field2)) continue;
            return method;
        }
        return null;
    }

    private static boolean checkFieldLocation(PsiMethod method, PsiField field) {
        return PsiResolveHelper.SERVICE.getInstance(method.getProject()).isAccessible(field, method, null) && (!method.hasModifier(JvmModifier.STATIC) || field.hasModifier(JvmModifier.STATIC)) && InheritanceUtil.isInheritorOrSelf(method.getContainingClass(), field.getContainingClass(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "prefix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "propertyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "field1";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/PropertyUtil";
        objectArray[2] = "findPropertyMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

