/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersFolder {
    private final Map<PsiVariable, PsiExpression> myExpressions = new HashMap<PsiVariable, PsiExpression>();
    private final Map<PsiVariable, String> myArgs = new HashMap<PsiVariable, String>();
    private final Map<PsiVariable, List<PsiExpression>> myMentionedInExpressions = new HashMap<PsiVariable, List<PsiExpression>>();
    private final Set<PsiVariable> myDeleted = new HashSet<PsiVariable>();
    private boolean myFoldingSelectedByDefault;

    public void clear() {
        this.myExpressions.clear();
        this.myMentionedInExpressions.clear();
        this.myDeleted.clear();
    }

    public boolean isParameterSafeToDelete(@NotNull VariableData data2, @NotNull LocalSearchScope scope) {
        if (data2 == null) {
            ParametersFolder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(1);
        }
        block0: for (PsiReference reference : ReferencesSearch.search(data2.variable, scope)) {
            PsiElement expression2 = reference.getElement();
            while (expression2 != null) {
                for (PsiExpression psiExpression : this.myExpressions.values()) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent(expression2, psiExpression)) continue;
                    continue block0;
                }
                expression2 = PsiTreeUtil.getParentOfType(expression2, PsiExpression.class);
            }
            return false;
        }
        PsiExpression psiExpression = this.myExpressions.get(data2.variable);
        if (psiExpression == null) {
            return true;
        }
        for (PsiVariable variable2 : this.myExpressions.keySet()) {
            PsiExpression expr;
            if (variable2 == data2.variable || this.myDeleted.contains(variable2) || (expr = this.myExpressions.get(variable2)) == null || !PsiEquivalenceUtil.areElementsEquivalent(expr, psiExpression)) continue;
            this.myDeleted.add(data2.variable);
            return true;
        }
        return false;
    }

    public void foldParameterUsagesInBody(@NotNull List<VariableData> datum, PsiElement[] elements, SearchScope scope) {
        if (datum == null) {
            ParametersFolder.$$$reportNull$$$0(2);
        }
        LinkedHashMap equivalentExpressions = new LinkedHashMap();
        for (VariableData data2 : datum) {
            PsiExpression psiExpression;
            if (this.myDeleted.contains(data2.variable) || (psiExpression = this.myExpressions.get(data2.variable)) == null) continue;
            HashSet<PsiExpression> eqExpressions = new HashSet<PsiExpression>();
            for (PsiReference reference : ReferencesSearch.search(data2.variable, scope)) {
                PsiExpression expression2 = ParametersFolder.findEquivalent(psiExpression, reference.getElement());
                if (expression2 == null || !expression2.isValid()) continue;
                eqExpressions.add(expression2);
            }
            equivalentExpressions.put(data2, eqExpressions);
        }
        for (VariableData data2 : equivalentExpressions.keySet()) {
            Set eqExpressions = (Set)equivalentExpressions.get(data2);
            block3: for (PsiExpression expression3 : eqExpressions) {
                if (!expression3.isValid()) continue;
                PsiExpression refExpression = JavaPsiFacade.getElementFactory(expression3.getProject()).createExpressionFromText(data2.name, expression3);
                PsiElement replaced = expression3.replace(refExpression);
                for (PsiElement psiElement : elements) {
                    if (expression3 != psiElement) continue;
                    elements[i] = replaced;
                    continue block3;
                }
            }
        }
    }

    boolean isParameterFoldable(@NotNull VariableData data2, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables, UniqueNameGenerator nameGenerator2, String defaultName) {
        List<PsiExpression> mentionedInExpressions;
        if (data2 == null) {
            ParametersFolder.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(4);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(5);
        }
        if ((mentionedInExpressions = this.getMentionedExpressions(data2.variable, scope, inputVariables)) == null) {
            return false;
        }
        int currentRank = 0;
        PsiElement mostRanked = null;
        for (int i = mentionedInExpressions.size() - 1; i >= 0; --i) {
            int r;
            boolean arrayAccess;
            PsiExpression expression2 = mentionedInExpressions.get(i);
            boolean bl = arrayAccess = expression2 instanceof PsiArrayAccessExpression && !ParametersFolder.isConditional(expression2, scope);
            if (arrayAccess) {
                this.myFoldingSelectedByDefault = true;
            }
            if (currentRank >= (r = ParametersFolder.findUsedVariables(data2, inputVariables, expression2).size()) && (!arrayAccess || currentRank != r)) continue;
            currentRank = r;
            mostRanked = expression2;
        }
        if (mostRanked != null) {
            this.myExpressions.put(data2.variable, (PsiExpression)mostRanked);
            this.myArgs.put(data2.variable, mostRanked.getText());
            data2.type = RefactoringChangeUtil.getTypeByExpression((PsiExpression)mostRanked);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(mostRanked.getProject());
            SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, (PsiExpression)mostRanked, data2.type);
            if (nameInfo.names.length > 0 && !Comparing.equal(nameInfo.names[0], data2.name) && !Comparing.equal(nameInfo.names[0], defaultName)) {
                data2.name = nameInfo.names[0];
                ParametersFolder.setUniqueName(data2, nameGenerator2, scope, (PsiExpression)mostRanked);
            }
        }
        return mostRanked != null;
    }

    private static boolean isConditional(PsiElement expr, LocalSearchScope scope) {
        while (expr != null) {
            PsiElement parent2 = expr.getParent();
            if (parent2 != null && scope.containsRange(parent2.getContainingFile(), parent2.getTextRange())) {
                if (parent2 instanceof PsiIfStatement ? ((PsiIfStatement)parent2).getCondition() != expr : (parent2 instanceof PsiConditionalExpression ? ((PsiConditionalExpression)parent2).getCondition() != expr : parent2 instanceof PsiSwitchStatement && ((PsiSwitchStatement)parent2).getExpression() != expr)) {
                    return true;
                }
            } else {
                return false;
            }
            expr = parent2;
        }
        return false;
    }

    private static void setUniqueName(VariableData data2, UniqueNameGenerator nameGenerator2, LocalSearchScope scope, PsiExpression expr) {
        String name = data2.name;
        int idx = 1;
        while (true) {
            PsiVariable definedVariable;
            if (nameGenerator2.isUnique(name, "", "") && ((definedVariable = PsiResolveHelper.SERVICE.getInstance(expr.getProject()).resolveReferencedVariable(name, expr)) == null || !scope.containsRange(expr.getContainingFile(), definedVariable.getTextRange()))) break;
            name = data2.name + idx++;
        }
        data2.name = name;
        nameGenerator2.addExistingName(name);
    }

    private static Set<PsiVariable> findUsedVariables(VariableData data2, final List<? extends PsiVariable> inputVariables, PsiExpression expression2) {
        final HashSet<PsiVariable> found = new HashSet<PsiVariable>();
        expression2.accept(new JavaRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiVariable && inputVariables.contains(resolved)) {
                    found.add((PsiVariable)resolved);
                }
            }
        });
        found.remove(data2.variable);
        return found;
    }

    public boolean isFoldable() {
        return !this.myExpressions.isEmpty();
    }

    @Nullable
    private List<PsiExpression> getMentionedExpressions(PsiVariable var, LocalSearchScope scope, List<? extends PsiVariable> inputVariables) {
        if (this.myMentionedInExpressions.containsKey(var)) {
            return this.myMentionedInExpressions.get(var);
        }
        PsiElement[] scopeElements = scope.getScope();
        ArrayList<PsiExpression> expressions = null;
        block0: for (PsiReference reference : ReferencesSearch.search(var, scope)) {
            PsiElement expression2 = reference.getElement();
            if (expressions == null) {
                expressions = new ArrayList<PsiExpression>();
                while (expression2 instanceof PsiExpression) {
                    PsiType expressionType;
                    PsiElement parent2;
                    if (ParametersFolder.isAccessedForWriting((PsiExpression)expression2)) {
                        return null;
                    }
                    if (ParametersFolder.isAncestor(expression2, scopeElements) || ParametersFolder.dependsOnLocals(expression2, inputVariables) || (parent2 = expression2.getParent()) instanceof PsiExpressionStatement || (expressionType = ((PsiExpression)expression2).getType()) == null || PsiType.VOID.equals(expressionType) || ParametersFolder.isTooLongExpressionChain(expression2)) continue block0;
                    if (!ParametersFolder.isMethodNameExpression(expression2)) {
                        expressions.add((PsiExpression)expression2);
                    }
                    expression2 = PsiTreeUtil.getParentOfType(expression2, PsiExpression.class);
                }
                continue;
            }
            Iterator iterator2 = expressions.iterator();
            while (iterator2.hasNext()) {
                if (ParametersFolder.findEquivalent((PsiExpression)iterator2.next(), expression2) != null) continue;
                iterator2.remove();
            }
        }
        this.myMentionedInExpressions.put(var, expressions);
        return expressions;
    }

    private static boolean isAccessedForWriting(PsiExpression expression2) {
        final PsiExpression[] exprWithWriteAccessInside = new PsiExpression[1];
        expression2.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (exprWithWriteAccessInside[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            @Override
            public void visitExpression(PsiExpression expression2) {
                if (PsiUtil.isAccessedForWriting(expression2)) {
                    exprWithWriteAccessInside[0] = expression2;
                }
                super.visitExpression(expression2);
            }
        });
        return exprWithWriteAccessInside[0] != null;
    }

    private static boolean isAncestor(PsiElement expression2, PsiElement[] scopeElements) {
        for (PsiElement scopeElement : scopeElements) {
            if (!PsiTreeUtil.isAncestor(expression2, scopeElement, true)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTooLongExpressionChain(PsiElement expression2) {
        int count2 = 0;
        PsiElement element = ParametersFolder.getInnerExpression(expression2);
        while (element != null) {
            if (++count2 > 1) {
                return true;
            }
            element = ParametersFolder.getInnerExpression(element);
        }
        return false;
    }

    private static PsiElement getInnerExpression(PsiElement expression2) {
        if (expression2 instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression();
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            while (expression2 instanceof PsiArrayAccessExpression) {
                expression2 = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            }
            return expression2;
        }
        return null;
    }

    private static boolean isMethodNameExpression(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(6);
        }
        PsiElement parent2 = expression2.getParent();
        return expression2 instanceof PsiReferenceExpression && parent2 instanceof PsiMethodCallExpression && ((PsiReferenceExpression)expression2).getReferenceNameElement() == ((PsiMethodCallExpression)parent2).getMethodExpression().getReferenceNameElement();
    }

    private static boolean dependsOnLocals(PsiElement expression2, final List<? extends PsiVariable> inputVariables) {
        final boolean[] localVarsUsed = new boolean[]{false};
        expression2.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiVariable variable2;
                PsiElement resolved = expression2.resolve();
                if (resolved instanceof PsiVariable && !((variable2 = (PsiVariable)resolved) instanceof PsiField) && !inputVariables.contains(variable2)) {
                    localVarsUsed[0] = true;
                    return;
                }
                super.visitReferenceExpression(expression2);
            }
        });
        return localVarsUsed[0];
    }

    @NotNull
    public String getGeneratedCallArgument(@NotNull VariableData data2) {
        if (data2 == null) {
            ParametersFolder.$$$reportNull$$$0(7);
        }
        String string = this.myArgs.containsKey(data2.variable) ? this.myArgs.get(data2.variable) : data2.variable.getName();
        if (string == null) {
            ParametersFolder.$$$reportNull$$$0(8);
        }
        return string;
    }

    void putCallArgument(@NotNull PsiVariable argument, @NotNull PsiExpression value) {
        if (argument == null) {
            ParametersFolder.$$$reportNull$$$0(9);
        }
        if (value == null) {
            ParametersFolder.$$$reportNull$$$0(10);
        }
        this.myArgs.put(argument, value.getText());
    }

    public boolean annotateWithParameter(@NotNull VariableData data2, @NotNull PsiElement element) {
        PsiExpression expression2;
        PsiExpression psiExpression;
        if (data2 == null) {
            ParametersFolder.$$$reportNull$$$0(11);
        }
        if (element == null) {
            ParametersFolder.$$$reportNull$$$0(12);
        }
        if ((psiExpression = this.myExpressions.get(data2.variable)) != null && (expression2 = ParametersFolder.findEquivalent(psiExpression, element)) != null) {
            expression2.putUserData(DuplicatesFinder.PARAMETER, Pair.create(data2.variable, expression2.getType()));
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiExpression findEquivalent(PsiExpression expr, PsiElement element) {
        PsiElement expression2 = element;
        while (expression2 != null) {
            if (PsiEquivalenceUtil.areElementsEquivalent(expression2, expr)) {
                PsiExpression psiExpression = (PsiExpression)expression2;
                return PsiUtil.isAccessedForWriting(psiExpression) ? null : psiExpression;
            }
            expression2 = PsiTreeUtil.getParentOfType(expression2, PsiExpression.class);
        }
        return null;
    }

    public boolean wasExcluded(PsiVariable variable2) {
        return this.myDeleted.contains(variable2) || this.myMentionedInExpressions.containsKey(variable2) && this.myExpressions.get(variable2) == null;
    }

    public boolean isFoldingSelectedByDefault() {
        return this.myFoldingSelectedByDefault;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datum";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ParametersFolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametersFolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedCallArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isParameterSafeToDelete";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "foldParameterUsagesInBody";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isParameterFoldable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMethodNameExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedCallArgument";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putCallArgument";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "annotateWithParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

