/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.List;

class ComplexityHolder {
    static final int MAX_ACCEPTABLE = 9;
    static final int TOO_COMPLEX = 100;
    private final ObjectIntHashMap<PsiExpression> myCache = new ObjectIntHashMap();
    private final List<PsiElement> myScope;

    ComplexityHolder(List<PsiElement> scope) {
        this.myScope = scope;
    }

    boolean isAcceptableExpression(PsiExpression expression2) {
        return this.getComplexity(expression2) <= 9;
    }

    private int getComplexity(PsiExpression expression2) {
        int complexity = this.myCache.get(expression2);
        if (complexity < 0) {
            complexity = this.computeComplexity(expression2);
            this.myCache.put(expression2, complexity);
        }
        return complexity;
    }

    private int computeComplexity(PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiLiteralExpression || expression2 instanceof PsiQualifiedExpression) {
            return 1;
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            return 100;
        }
        if (expression2 instanceof PsiUnaryExpression) {
            IElementType tokenType = ((PsiUnaryExpression)expression2).getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                return 100;
            }
            return 1 + this.getComplexity(((PsiUnaryExpression)expression2).getOperand());
        }
        if (expression2 instanceof PsiBinaryExpression) {
            int complexity = 1 + this.getComplexity(((PsiBinaryExpression)expression2).getLOperand());
            if (complexity > 9) {
                return complexity;
            }
            return complexity + this.getComplexity(((PsiBinaryExpression)expression2).getROperand());
        }
        if (expression2 instanceof PsiConditionalExpression) {
            int complexity = 1 + this.getComplexity(((PsiConditionalExpression)expression2).getCondition());
            if (complexity > 9) {
                return complexity;
            }
            if ((complexity += this.getComplexity(((PsiConditionalExpression)expression2).getThenExpression())) > 9) {
                return complexity;
            }
            return complexity + this.getComplexity(((PsiConditionalExpression)expression2).getElseExpression());
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            int complexity = 3 + this.getComplexity(((PsiArrayAccessExpression)expression2).getArrayExpression());
            if (complexity > 9) {
                return complexity;
            }
            return complexity + this.getComplexity(((PsiArrayAccessExpression)expression2).getIndexExpression());
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement resolved = ((PsiReferenceExpression)expression2).resolve();
            if (resolved == null || this.isWithinScope(resolved)) {
                return 100;
            }
            if (resolved instanceof PsiVariable && ((PsiVariable)resolved).hasModifierProperty("static") && ((PsiVariable)resolved).hasModifierProperty("final")) {
                return 1;
            }
            PsiExpression qualifier = ((PsiReferenceExpression)expression2).getQualifierExpression();
            if (qualifier == null) {
                return 2;
            }
            return 2 + this.getComplexity(qualifier);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiExpression[] arguments2;
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression2).getMethodExpression();
            PsiElement resolved = methodExpression.resolve();
            if (resolved == null || this.isWithinScope(resolved)) {
                return 100;
            }
            int complexity = 3;
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && (complexity += this.getComplexity(qualifier)) > 9) {
                return complexity;
            }
            for (PsiExpression argument : arguments2 = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()) {
                if ((complexity += this.getComplexity(argument)) <= 9) continue;
                return complexity;
            }
            return complexity;
        }
        return 100;
    }

    private boolean isWithinScope(PsiElement resolved) {
        return DuplicatesFinder.isUnder(resolved, this.myScope);
    }

    public List<PsiElement> getScope() {
        return this.myScope;
    }
}

