/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import gnu.trove.Equality;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayUtil
extends ArrayUtilRt {
    public static final short[] EMPTY_SHORT_ARRAY = ArrayUtilRt.EMPTY_SHORT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final Collection[] EMPTY_COLLECTION_ARRAY = ArrayUtilRt.EMPTY_COLLECTION_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = ArrayUtilRt.EMPTY_RUNNABLE_ARRAY;
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = new ArrayFactory<String>(){

        @NotNull
        public String[] create(int count2) {
            String[] stringArray = ArrayUtil.newStringArray(count2);
            if (stringArray == null) {
                1.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$1", "create"));
        }
    };
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = new ArrayFactory<Object>(){

        @Override
        @NotNull
        public Object[] create(int count2) {
            Object[] objectArray = ArrayUtil.newObjectArray(count2);
            if (objectArray == null) {
                2.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$2", "create"));
        }
    };

    private ArrayUtil() {
    }

    @NotNull
    @Contract(pure=true)
    public static byte[] realloc(@NotNull byte[] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(0);
        }
        if (newSize == 0) {
            if (EMPTY_BYTE_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(1);
            }
            return EMPTY_BYTE_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(2);
            }
            return array;
        }
        byte[] result2 = new byte[newSize];
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(3);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static boolean[] realloc(@NotNull boolean[] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(4);
        }
        if (newSize == 0) {
            if (EMPTY_BOOLEAN_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(5);
            }
            return EMPTY_BOOLEAN_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(6);
            }
            return array;
        }
        boolean[] result2 = new boolean[newSize];
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(7);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] realloc(@NotNull long[] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(8);
        }
        if (newSize == 0) {
            if (EMPTY_LONG_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(9);
            }
            return EMPTY_LONG_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(10);
            }
            return array;
        }
        long[] result2 = new long[newSize];
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(11);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] realloc(@NotNull int[] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(12);
        }
        if (newSize == 0) {
            if (EMPTY_INT_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(13);
            }
            return EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(14);
            }
            return array;
        }
        int[] result2 = new int[newSize];
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(15);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] realloc(@NotNull T[] array, int newSize, @NotNull ArrayFactory<T> factory2) {
        int oldSize;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(16);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(17);
        }
        if ((oldSize = array.length) == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(18);
            }
            return array;
        }
        T[] result2 = factory2.create(newSize);
        if (newSize == 0) {
            if (result2 == null) {
                ArrayUtil.$$$reportNull$$$0(19);
            }
            return result2;
        }
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(20);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] append(@NotNull long[] array, long value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(21);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(22);
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] append(@NotNull int[] array, int value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(23);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(24);
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] insert(@NotNull T[] array, int index2, T value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(25);
        }
        T[] result2 = ArrayUtil.createArray(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, result2, 0, index2);
        result2[index2] = value;
        System.arraycopy(array, index2, result2, index2 + 1, array.length - index2);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(26);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] insert(@NotNull int[] array, int index2, int value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(27);
        }
        int[] result2 = new int[array.length + 1];
        System.arraycopy(array, 0, result2, 0, index2);
        result2[index2] = value;
        System.arraycopy(array, index2, result2, index2 + 1, array.length - index2);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(28);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static byte[] append(@NotNull byte[] array, byte value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(29);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(30);
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static boolean[] append(@NotNull boolean[] array, boolean value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(31);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(32);
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static char[] realloc(@NotNull char[] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(33);
        }
        if (newSize == 0) {
            if (EMPTY_CHAR_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(34);
            }
            return EMPTY_CHAR_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(35);
            }
            return array;
        }
        char[] result2 = new char[newSize];
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(36);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toObjectArray(@NotNull Collection<? extends T> collection, @NotNull Class<T> aClass2) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(37);
        }
        if (aClass2 == null) {
            ArrayUtil.$$$reportNull$$$0(38);
        }
        T[] array = ArrayUtil.createArray(aClass2, collection.size());
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(39);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toObjectArray(@NotNull Class<T> aClass2, Object ... source) {
        if (aClass2 == null) {
            ArrayUtil.$$$reportNull$$$0(40);
        }
        if (source == null) {
            ArrayUtil.$$$reportNull$$$0(41);
        }
        T[] array = ArrayUtil.createArray(aClass2, source.length);
        System.arraycopy(source, 0, array, 0, array.length);
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(42);
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] toObjectArray(@NotNull Collection<?> collection) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(43);
        }
        if (collection.isEmpty()) {
            if (EMPTY_OBJECT_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(44);
            }
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = collection.toArray(new Object[collection.size()]);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(45);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] toIntArray(@NotNull Collection<Integer> list2) {
        if (list2 == null) {
            ArrayUtil.$$$reportNull$$$0(46);
        }
        int[] ret = ArrayUtil.newIntArray(list2.size());
        int i = 0;
        for (Integer e : list2) {
            ret[i++] = e;
        }
        if (ret == null) {
            ArrayUtil.$$$reportNull$$$0(47);
        }
        return ret;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2) {
        Class<?> class2;
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(48);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(49);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(50);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(51);
            }
            return a1;
        }
        Class<?> class1 = a1.getClass().getComponentType();
        Class<?> aClass2 = class1.isAssignableFrom(class2 = a2.getClass().getComponentType()) ? class1 : class2;
        T[] result2 = ArrayUtil.createArray(aClass2, a1.length + a2.length);
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(52);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeCollections(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory2) {
        if (c1 == null) {
            ArrayUtil.$$$reportNull$$$0(53);
        }
        if (c2 == null) {
            ArrayUtil.$$$reportNull$$$0(54);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(55);
        }
        T[] res2 = factory2.create(c1.size() + c2.size());
        int i = 0;
        for (T t : c1) {
            res2[i++] = t;
        }
        for (T t : c2) {
            res2[i++] = t;
        }
        if (res2 == null) {
            ArrayUtil.$$$reportNull$$$0(56);
        }
        return res2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2, @NotNull ArrayFactory<T> factory2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(57);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(58);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(59);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(60);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(61);
            }
            return a1;
        }
        T[] result2 = factory2.create(a1.length + a2.length);
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(62);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] mergeArrays(@NotNull String[] a1, String ... a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(63);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(64);
        }
        String[] stringArray = ArrayUtil.mergeArrays(a1, a2, STRING_ARRAY_FACTORY);
        if (stringArray == null) {
            ArrayUtil.$$$reportNull$$$0(65);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] mergeArrays(@NotNull int[] a1, @NotNull int[] a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(66);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(67);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(68);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(69);
            }
            return a1;
        }
        int[] result2 = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(70);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static byte[] mergeArrays(@NotNull byte[] a1, @NotNull byte[] a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(71);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(72);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(73);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(74);
            }
            return a1;
        }
        byte[] result2 = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(75);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrayAndCollection(@NotNull T[] array, @NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory2) {
        T[] array2;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(76);
        }
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(77);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(78);
        }
        if (collection.isEmpty()) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(79);
            }
            return array;
        }
        try {
            array2 = collection.toArray(factory2.create(collection.size()));
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Bad elements in collection: " + collection, e);
        }
        if (array.length == 0) {
            if (array2 == null) {
                ArrayUtil.$$$reportNull$$$0(80);
            }
            return array2;
        }
        T[] result2 = factory2.create(array.length + collection.size());
        System.arraycopy(array, 0, result2, 0, array.length);
        System.arraycopy(array2, 0, result2, array.length, array2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(81);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(82);
        }
        T[] TArray = ArrayUtil.append(src, element, src.getClass().getComponentType());
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(83);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(84);
        }
        T[] TArray = ArrayUtil.prepend(element, array, array.getClass().getComponentType());
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(85);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array, @NotNull Class<T> type2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(86);
        }
        if (type2 == null) {
            ArrayUtil.$$$reportNull$$$0(87);
        }
        int length = array.length;
        T[] result2 = ArrayUtil.createArray(type2, length + 1);
        System.arraycopy(array, 0, result2, 1, length);
        result2[0] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(88);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] src, @NotNull ArrayFactory<T> factory2) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(89);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(90);
        }
        int length = src.length;
        T[] result2 = factory2.create(length + 1);
        System.arraycopy(src, 0, result2, 1, length);
        result2[0] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(91);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static byte[] prepend(byte element, @NotNull byte[] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(92);
        }
        int length = array.length;
        byte[] result2 = new byte[length + 1];
        result2[0] = element;
        System.arraycopy(array, 0, result2, 1, length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(93);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory2) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(94);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(95);
        }
        int length = src.length;
        T[] result2 = factory2.create(length + 1);
        System.arraycopy(src, 0, result2, 0, length);
        result2[length] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(96);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(97);
        }
        if (componentType == null) {
            ArrayUtil.$$$reportNull$$$0(98);
        }
        int length = src.length;
        T[] result2 = ArrayUtil.createArray(componentType, length + 1);
        System.arraycopy(src, 0, result2, 0, length);
        result2[length] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(99);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(100);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result2 = ArrayUtil.createArray(src.getClass().getComponentType(), length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(101);
        }
        return result2;
    }

    @NotNull
    private static <T> T[] createArray(@NotNull Class<?> type2, int length) {
        if (type2 == null) {
            ArrayUtil.$$$reportNull$$$0(102);
        }
        Object[] objectArray = (Object[])Array.newInstance(type2, length);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(103);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx, @NotNull ArrayFactory<T> factory2) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(104);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(105);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result2 = factory2.create(length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(106);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, T element) {
        int idx;
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(107);
        }
        if ((idx = ArrayUtil.find(src, element)) == -1) {
            if (src == null) {
                ArrayUtil.$$$reportNull$$$0(108);
            }
            return src;
        }
        int[] nArray = ArrayUtil.remove(src, idx);
        if (nArray == null) {
            ArrayUtil.$$$reportNull$$$0(109);
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory2) {
        int idx;
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(110);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(111);
        }
        if ((idx = ArrayUtil.find(src, element)) == -1) {
            if (src == null) {
                ArrayUtil.$$$reportNull$$$0(112);
            }
            return src;
        }
        int[] nArray = ArrayUtil.remove(src, idx, factory2);
        if (nArray == null) {
            ArrayUtil.$$$reportNull$$$0(113);
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] remove(@NotNull int[] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(114);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result2 = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(115);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static short[] remove(@NotNull short[] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(116);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        short[] result2 = src.length == 1 ? EMPTY_SHORT_ARRAY : new short[src.length - 1];
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(117);
        }
        return result2;
    }

    @Contract(pure=true)
    public static int find(@NotNull int[] src, int obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(118);
        }
        return ArrayUtil.indexOf(src, obj);
    }

    @Contract(pure=true)
    public static <T> int find(@NotNull T[] src, T obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(119);
        }
        return ArrayUtilRt.find(src, obj);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull byte[] array, @NotNull byte[] prefix) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(120);
        }
        if (prefix == null) {
            ArrayUtil.$$$reportNull$$$0(121);
        }
        if (array == prefix) {
            return true;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <E> boolean startsWith(@NotNull E[] array, @NotNull E[] subArray) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(122);
        }
        if (subArray == null) {
            ArrayUtil.$$$reportNull$$$0(123);
        }
        if (array == subArray) {
            return true;
        }
        int length = subArray.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Comparing.equal(array[i], subArray[i])) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull byte[] array, int start, @NotNull byte[] subArray) {
        int length;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(124);
        }
        if (subArray == null) {
            ArrayUtil.$$$reportNull$$$0(125);
        }
        if (array.length - start < (length = subArray.length)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[start + i] == subArray[i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean equals(@NotNull T[] a1, @NotNull T[] a2, @NotNull Equality<? super T> comparator) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(126);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(127);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(128);
        }
        if (a1 == a2) {
            return true;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean equals(@NotNull T[] a1, @NotNull T[] a2, @NotNull Comparator<? super T> comparator) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(129);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(130);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(131);
        }
        if (a1 == a2) {
            return true;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.compare(a1[i], a2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] reverseArray(@NotNull T[] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(132);
        }
        Object[] newArray = (Object[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        if (newArray == null) {
            ArrayUtil.$$$reportNull$$$0(133);
        }
        return newArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] reverseArray(@NotNull int[] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(134);
        }
        int[] newArray = (int[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        if (newArray == null) {
            ArrayUtil.$$$reportNull$$$0(135);
        }
        return newArray;
    }

    @Contract(pure=true)
    public static int lexicographicCompare(@NotNull String[] obj1, @NotNull String[] obj2) {
        if (obj1 == null) {
            ArrayUtil.$$$reportNull$$$0(136);
        }
        if (obj2 == null) {
            ArrayUtil.$$$reportNull$$$0(137);
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            String o2;
            String o1 = i < obj1.length ? obj1[i] : null;
            String string = o2 = i < obj2.length ? obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res2 = o1.compareToIgnoreCase(o2);
            if (res2 == 0) continue;
            return res2;
        }
        return 0;
    }

    @Contract(pure=true)
    public static <T> int lexicographicCompare(@NotNull T[] obj1, @NotNull T[] obj2) {
        if (obj1 == null) {
            ArrayUtil.$$$reportNull$$$0(138);
        }
        if (obj2 == null) {
            ArrayUtil.$$$reportNull$$$0(139);
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            Object o2;
            Object o1 = i < obj1.length ? obj1[i] : null;
            Object t = o2 = i < obj2.length ? (Object)obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res2 = ((Comparable)o1).compareTo(o2);
            if (res2 == 0) continue;
            return res2;
        }
        return 0;
    }

    public static <T> void swap(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(140);
        }
        T t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull int[] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(141);
        }
        int t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull boolean[] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(142);
        }
        boolean t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull char[] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(143);
        }
        char t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static <T> void rotateLeft(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(144);
        }
        T t = array[i1];
        System.arraycopy(array, i1 + 1, array, i1, i2 - i1);
        array[i2] = t;
    }

    public static <T> void rotateRight(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(145);
        }
        T t = array[i2];
        System.arraycopy(array, i1, array, i1 + 1, i2 - i1);
        array[i1] = t;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull Object[] objects, @Nullable Object object) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(146);
        }
        return ArrayUtil.indexOf(objects, object, 0, objects.length);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull Object[] objects, Object object, int start, int end) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(147);
        }
        if (object == null) {
            for (int i = start; i < end; ++i) {
                if (objects[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!object.equals(objects[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(148);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(149);
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (!comparator.equals(objects.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Comparator<T> comparator) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(150);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(151);
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (comparator.compare(objects.get(i), object) != 0) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull T[] objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(152);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(153);
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!comparator.equals(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull long[] ints, long value) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(154);
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull int[] ints, int value) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(155);
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull short[] ints, short value) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(156);
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull byte[] ints, byte value, int start, int end) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(157);
        }
        for (int i = start; i < end; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull T[] src, T obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(158);
        }
        for (int i = src.length - 1; i >= 0; --i) {
            T o = src[i];
            if (!(o == null ? obj == null : o.equals(obj))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull int[] src, int obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(159);
        }
        for (int i = src.length - 1; i >= 0; --i) {
            int o = src[i];
            if (o != obj) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull T[] src, T obj, @NotNull Equality<? super T> comparator) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(160);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(161);
        }
        for (int i = src.length - 1; i >= 0; --i) {
            T o = src[i];
            if (!comparator.equals(obj, o)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<T> src, T obj, @NotNull Equality<? super T> comparator) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(162);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(163);
        }
        for (int i = src.size() - 1; i >= 0; --i) {
            T o = src.get(i);
            if (!comparator.equals(obj, o)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean contains(@Nullable T o, T ... objects) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(164);
        }
        return ArrayUtil.indexOf(objects, o) >= 0;
    }

    @Contract(pure=true)
    public static boolean contains(@Nullable String s, String ... strings) {
        if (strings == null) {
            ArrayUtil.$$$reportNull$$$0(165);
        }
        if (s == null) {
            for (String str : strings) {
                if (str != null) continue;
                return true;
            }
        } else {
            for (String str : strings) {
                if (!s.equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] newIntArray(int count2) {
        int[] nArray = count2 == 0 ? EMPTY_INT_ARRAY : new int[count2];
        if (nArray == null) {
            ArrayUtil.$$$reportNull$$$0(166);
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] newLongArray(int count2) {
        long[] lArray = count2 == 0 ? EMPTY_LONG_ARRAY : new long[count2];
        if (lArray == null) {
            ArrayUtil.$$$reportNull$$$0(167);
        }
        return lArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] newStringArray(int count2) {
        String[] stringArray = count2 == 0 ? EMPTY_STRING_ARRAY : new String[count2];
        if (stringArray == null) {
            ArrayUtil.$$$reportNull$$$0(168);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] newObjectArray(int count2) {
        Object[] objectArray = count2 == 0 ? EMPTY_OBJECT_ARRAY : new Object[count2];
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(169);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> E[] ensureExactSize(int count2, @NotNull E[] sample) {
        if (sample == null) {
            ArrayUtil.$$$reportNull$$$0(170);
        }
        if (count2 == sample.length) {
            if (sample == null) {
                ArrayUtil.$$$reportNull$$$0(171);
            }
            return sample;
        }
        T[] array = ArrayUtil.createArray(sample.getClass().getComponentType(), count2);
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(172);
        }
        return array;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstElement(@Nullable T[] array) {
        return array != null && array.length > 0 ? (T)array[0] : null;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getLastElement(@Nullable T[] array) {
        return array != null && array.length > 0 ? (T)array[array.length - 1] : null;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable T[] array) {
        return array == null || array.length == 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] toStringArray(@Nullable Collection<String> collection) {
        String[] stringArray = ArrayUtilRt.toStringArray(collection);
        if (stringArray == null) {
            ArrayUtil.$$$reportNull$$$0(173);
        }
        return stringArray;
    }

    public static <T> void copy(@NotNull Collection<? extends T> src, @NotNull T[] dst, int dstOffset) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(174);
        }
        if (dst == null) {
            ArrayUtil.$$$reportNull$$$0(175);
        }
        int i = dstOffset;
        for (T t : src) {
            dst[i++] = t;
        }
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static <T> T[] copyOf(@Nullable T[] original) {
        if (original == null) {
            return null;
        }
        return Arrays.copyOf(original, original.length);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static boolean[] copyOf(@Nullable boolean[] original) {
        if (original == null) {
            return null;
        }
        return Arrays.copyOf(original, original.length);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static int[] copyOf(@Nullable int[] original) {
        if (original == null) {
            return null;
        }
        return Arrays.copyOf(original, original.length);
    }

    @NotNull
    public static <T> T[] stripTrailingNulls(@NotNull T[] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(176);
        }
        T[] TArray = array.length != 0 && array[array.length - 1] == null ? Arrays.copyOf(array, ArrayUtil.trailingNullsIndex(array)) : array;
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(177);
        }
        return TArray;
    }

    private static <T> int trailingNullsIndex(@NotNull T[] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(178);
        }
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == null) continue;
            return i + 1;
        }
        return 0;
    }

    public static long averageAmongMedians(@NotNull long[] time, int part) {
        if (time == null) {
            ArrayUtil.$$$reportNull$$$0(179);
        }
        assert (part >= 1);
        int n = time.length;
        Arrays.sort(time);
        long total = 0L;
        int start = n / 2 - n / part / 2;
        int end = n / 2 + n / part / 2;
        for (int i = start; i < end; ++i) {
            total += time[i];
        }
        int middlePartLength = end - start;
        return middlePartLength == 0 ? 0L : total / (long)middlePartLength;
    }

    public static long averageAmongMedians(@NotNull int[] time, int part) {
        if (time == null) {
            ArrayUtil.$$$reportNull$$$0(180);
        }
        assert (part >= 1);
        int n = time.length;
        Arrays.sort(time);
        long total = 0L;
        int start = n / 2 - n / part / 2;
        int end = n / 2 + n / part / 2;
        for (int i = start; i < end; ++i) {
            total += (long)time[i];
        }
        int middlePartLength = end - start;
        return middlePartLength == 0 ? 0L : total / (long)middlePartLength;
    }

    public static int min(int[] values2) {
        int min = Integer.MAX_VALUE;
        for (int value : values2) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 101: 
            case 103: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 133: 
            case 135: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 101: 
            case 103: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 133: 
            case 135: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 101: 
            case 103: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 133: 
            case 135: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 17: 
            case 55: 
            case 59: 
            case 78: 
            case 90: 
            case 95: 
            case 105: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 37: 
            case 43: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 48: 
            case 57: 
            case 63: 
            case 66: 
            case 71: 
            case 126: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 49: 
            case 58: 
            case 64: 
            case 67: 
            case 72: 
            case 127: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 82: 
            case 89: 
            case 94: 
            case 97: 
            case 100: 
            case 104: 
            case 107: 
            case 110: 
            case 114: 
            case 116: 
            case 118: 
            case 119: 
            case 158: 
            case 159: 
            case 160: 
            case 162: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 87: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 123: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subArray";
                break;
            }
            case 128: 
            case 131: 
            case 149: 
            case 151: 
            case 153: 
            case 161: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj1";
                break;
            }
            case 137: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj2";
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 152: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ints";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 179: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "realloc";
                break;
            }
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 83: 
            case 96: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
            case 39: 
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "toObjectArray";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntArray";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrays";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollections";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrayAndCollection";
                break;
            }
            case 85: 
            case 88: 
            case 91: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 101: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 115: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "createArray";
                break;
            }
            case 133: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseArray";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "newIntArray";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "newLongArray";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "newStringArray";
                break;
            }
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "newObjectArray";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureExactSize";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingNulls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "realloc";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 101: 
            case 103: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 133: 
            case 135: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                break;
            }
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 82: 
            case 94: 
            case 95: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "toObjectArray";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "toIntArray";
                break;
            }
            case 48: 
            case 49: 
            case 57: 
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrays";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollections";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrayAndCollection";
                break;
            }
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 100: 
            case 104: 
            case 105: 
            case 107: 
            case 110: 
            case 111: 
            case 114: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "createArray";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 132: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "reverseArray";
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "lexicographicCompare";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "swap";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "ensureExactSize";
                break;
            }
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingNulls";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "trailingNullsIndex";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "averageAmongMedians";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 101: 
            case 103: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 133: 
            case 135: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

