/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EventDispatcher");
    private final T myMulticaster;
    private final List<T> myListeners;

    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(0);
        }
        return new EventDispatcher<T>(listenerClass);
    }

    private EventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMulticaster = (EventListener)EventDispatcher.createMulticaster(listenerClass, new Getter<Iterable<T>>(){

            @Override
            public Iterable<T> get() {
                return EventDispatcher.this.myListeners;
            }
        });
    }

    @NotNull
    static <T> T createMulticaster(@NotNull Class<T> listenerClass, final Getter<Iterable<T>> listeners) {
        if (listenerClass == null) {
            EventDispatcher.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(listenerClass.isInterface(), "listenerClass must be an interface");
        InvocationHandler handler2 = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                    String methodName = method.getName();
                    if (methodName.equals("toString")) {
                        return "Multicaster";
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy2);
                    }
                    if (methodName.equals("equals")) {
                        return proxy2 == args[0] ? Boolean.TRUE : Boolean.FALSE;
                    }
                    LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
                    return null;
                }
                EventDispatcher.dispatch((Iterable)listeners.get(), method, args);
                return null;
            }
        };
        Object object = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler2);
        if (object == null) {
            EventDispatcher.$$$reportNull$$$0(3);
        }
        return (T)object;
    }

    @NotNull
    public T getMulticaster() {
        T t = this.myMulticaster;
        if (t == null) {
            EventDispatcher.$$$reportNull$$$0(4);
        }
        return t;
    }

    private static <T> void dispatch(Iterable<T> listeners, @NotNull Method method, Object[] args) {
        if (method == null) {
            EventDispatcher.$$$reportNull$$$0(5);
        }
        method.setAccessible(true);
        for (T listener : listeners) {
            try {
                method.invoke(listener, args);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                ExceptionUtil.rethrowUnchecked(cause);
                if (cause instanceof AbstractMethodError) continue;
                LOG.error(cause);
            }
        }
    }

    public void addListener(@NotNull T listener) {
        if (listener == null) {
            EventDispatcher.$$$reportNull$$$0(6);
        }
        this.myListeners.add(listener);
    }

    public void addListener(@NotNull T listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            EventDispatcher.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            EventDispatcher.$$$reportNull$$$0(8);
        }
        this.addListener(listener);
        Disposer.register(parentDisposable, new Disposable((EventListener)listener){
            final /* synthetic */ EventListener val$listener;
            {
                this.val$listener = eventListener;
            }

            @Override
            public void dispose() {
                EventDispatcher.this.removeListener(this.val$listener);
            }
        });
    }

    public void removeListener(@NotNull T listener) {
        if (listener == null) {
            EventDispatcher.$$$reportNull$$$0(9);
        }
        this.myListeners.remove(listener);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    @NotNull
    public List<T> getListeners() {
        List<T> list2 = this.myListeners;
        if (list2 == null) {
            EventDispatcher.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EventDispatcher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EventDispatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMulticaster";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMulticaster";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMulticaster";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

