/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;

public class EventUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EventUtil");

    public static <T extends EventListener> T createWeakListener(Class<T> listenerClass, T listener) {
        final WeakReference<T> reference = new WeakReference<T>(listener);
        InvocationHandler handler2 = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
                Object o = reference.get();
                if (o == null) {
                    if ("equals".equals(method.getName())) {
                        return Boolean.FALSE;
                    }
                    return null;
                }
                try {
                    Object result2 = method.invoke(o, args);
                    return result2;
                }
                catch (IllegalAccessException e) {
                    LOG.error(e);
                }
                catch (IllegalArgumentException e) {
                    LOG.error(e);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                return null;
            }
        };
        return (T)((EventListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler2));
    }
}

