/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UnsignedShortArrayList;
import java.awt.EventQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class PausesStat {
    private static final Logger LOG = Logger.getInstance(PausesStat.class);
    private static final int N_MAX = 100000;
    private final UnsignedShortArrayList durations;
    @NotNull
    private final String myName;
    private final Thread myEdtThread;
    private boolean started;
    private long startTimeStamp;
    private int maxDuration;
    private Object maxDurationDescription;
    private int totalNumberRecorded;
    private int indexToOverwrite;
    private String startDescription;

    public PausesStat(@NotNull String name) {
        if (name == null) {
            PausesStat.$$$reportNull$$$0(0);
        }
        this.durations = new UnsignedShortArrayList();
        this.myName = name;
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("expected EDT but got " + Thread.currentThread());
        }
        this.myEdtThread = Thread.currentThread();
    }

    private void register(int duration) {
        if (this.durations.size() == 100000) {
            this.durations.set(this.indexToOverwrite, duration);
            this.indexToOverwrite = (this.indexToOverwrite + 1) % 100000;
        } else {
            this.durations.add(duration);
        }
    }

    public void started(@NotNull String description2) {
        if (description2 == null) {
            PausesStat.$$$reportNull$$$0(1);
        }
        this.assertEdt();
        LOG.assertTrue(!this.started);
        LOG.assertTrue(this.startTimeStamp == 0L, this.startTimeStamp);
        this.startTimeStamp = System.nanoTime();
        this.started = true;
        this.startDescription = description2;
    }

    private void assertEdt() {
        if (Thread.currentThread() != this.myEdtThread) {
            LOG.error("wrong thread: " + Thread.currentThread());
        }
    }

    public void finished(@NotNull String description2) {
        if (description2 == null) {
            PausesStat.$$$reportNull$$$0(2);
        }
        this.assertEdt();
        LOG.assertTrue(this.started);
        this.started = false;
        long finishStamp = System.nanoTime();
        long startTimeStamp = this.startTimeStamp;
        int durationMs = (int)TimeUnit.NANOSECONDS.toMillis(finishStamp - startTimeStamp);
        this.startTimeStamp = 0L;
        if (finishStamp - startTimeStamp < 0L || durationMs < 0) {
            return;
        }
        if ((durationMs = Math.min(durationMs, Short.MAX_VALUE)) > this.maxDuration) {
            this.maxDuration = durationMs;
            this.maxDurationDescription = description2;
        }
        ++this.totalNumberRecorded;
        this.register(durationMs);
    }

    public String statistics() {
        int number = this.durations.size();
        int[] duration = this.durations.toArray();
        int total = 0;
        for (int d : duration) {
            total += d;
        }
        return this.myName + " Statistics" + (this.totalNumberRecorded == number ? "" : " (" + this.totalNumberRecorded + " events was recorded in total, but only last " + number + " are reported here)") + ":\nEvent number:     " + number + "\nTotal time spent: " + total + "ms\nAverage duration: " + (number == 0 ? 0 : total / number) + "ms\nMedian  duration: " + ArrayUtil.averageAmongMedians(duration, 3) + "ms\nMax  duration:    " + (this.maxDuration == 65535 ? ">" : "") + this.maxDuration + "ms (it was '" + this.maxDurationDescription + "')";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/PausesStat";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "started";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "finished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

