/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

public class ByteArrayQueue {
    private byte[] myArray;
    private int mySize;
    private int myTail;
    private int myHead;

    public ByteArrayQueue(int initialSize) {
        this.myArray = new byte[initialSize];
        this.mySize = 0;
        this.myTail = 0;
        this.myHead = 0;
    }

    public void add(byte b) {
        this.resizeIfNeeded(this.mySize + 1);
        this.doAdd(b);
    }

    public void addAll(byte[] buffer) {
        this.resizeIfNeeded(this.mySize + buffer.length);
        for (byte b : buffer) {
            this.doAdd(b);
        }
    }

    private void doAdd(byte b) {
        this.myArray[this.myTail] = b;
        ++this.myTail;
        if (this.myTail >= this.myArray.length) {
            this.myTail = 0;
        }
        ++this.mySize;
    }

    public int poll() {
        if (this.mySize == 0) {
            return -1;
        }
        byte res2 = this.myArray[this.myHead];
        ++this.myHead;
        if (this.myHead >= this.myArray.length) {
            this.myHead = 0;
        }
        --this.mySize;
        return res2;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public int size() {
        return this.mySize;
    }

    private void resizeIfNeeded(int newSize) {
        int len = this.myArray.length;
        if (newSize > len) {
            byte[] newArray = new byte[Math.max(len << 1, newSize)];
            if (this.myHead < this.myTail) {
                System.arraycopy(this.myArray, this.myHead, newArray, 0, this.myTail - this.myHead);
            } else {
                System.arraycopy(this.myArray, this.myHead, newArray, 0, len - this.myHead);
                System.arraycopy(this.myArray, 0, newArray, len - this.myHead, this.myTail);
            }
            this.myArray = newArray;
            this.myHead = 0;
            this.myTail = this.mySize;
        }
    }
}

