/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CircularCharBuffer {
    private char[] myArray;
    private final int myMaxCapacity;
    private int mySize;
    private int myTail;
    private int myHead;

    public CircularCharBuffer(int initialCapacity) {
        this(initialCapacity, Integer.MAX_VALUE);
    }

    public CircularCharBuffer(int initialCapacity, int maxCapacity) {
        if (maxCapacity <= 0 || initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("There must be 0 < initialCapacity <= maxCapacity, but got initialCapacity=" + initialCapacity + "; maxCapacity=" + maxCapacity);
        }
        this.myArray = new char[initialCapacity];
        this.myMaxCapacity = maxCapacity;
        this.mySize = 0;
        this.myTail = 0;
        this.myHead = 0;
    }

    public void add(char c) {
        this.resizeIfNeeded(this.mySize + 1);
        this.doAdd(c);
    }

    public void add(char[] buffer) {
        this.resizeIfNeeded(this.mySize + buffer.length);
        for (char c : buffer) {
            this.doAdd(c);
        }
    }

    public void add(@NotNull String str) {
        if (str == null) {
            CircularCharBuffer.$$$reportNull$$$0(0);
        }
        this.resizeIfNeeded(this.mySize + str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.doAdd(str.charAt(i));
        }
    }

    private void doAdd(char c) {
        this.myArray[this.myTail] = c;
        ++this.myTail;
        int length = this.myArray.length;
        if (this.myTail >= length) {
            this.myTail = 0;
        }
        ++this.mySize;
        if (this.mySize > length) {
            this.poll();
        }
    }

    public int poll() {
        if (this.mySize == 0) {
            return -1;
        }
        char res2 = this.myArray[this.myHead];
        ++this.myHead;
        if (this.myHead >= this.myArray.length) {
            this.myHead = 0;
        }
        --this.mySize;
        return res2;
    }

    @NotNull
    public String getText() {
        this.normalize();
        String string = new String(this.myArray, 0, this.mySize);
        if (string == null) {
            CircularCharBuffer.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public int size() {
        return this.mySize;
    }

    private boolean resizeIfNeeded(int newSize) {
        int length = this.myArray.length;
        if (newSize <= length) {
            return true;
        }
        if (length == this.myMaxCapacity) {
            return false;
        }
        this.normalize();
        int newLength = Math.min(this.myMaxCapacity, Math.max(length << 1, newSize));
        char[] newArray = new char[newLength];
        System.arraycopy(this.myArray, this.myHead, newArray, 0, this.mySize);
        this.myArray = newArray;
        this.myTail = this.mySize % newArray.length;
        return true;
    }

    private void normalize() {
        if (this.myHead == 0) {
            return;
        }
        int length = this.myArray.length;
        if (this.myHead < this.myTail) {
            CircularCharBuffer.moveSubArrayLeft(this.myArray, this.myHead, this.mySize, this.myHead);
        } else {
            int headSize = this.myTail;
            int tailSize = length - this.myHead;
            CircularCharBuffer.reverseSubArray(this.myArray, 0, headSize);
            CircularCharBuffer.reverseSubArray(this.myArray, length - tailSize, tailSize);
            CircularCharBuffer.reverseSubArray(this.myArray, 0, length);
            CircularCharBuffer.moveSubArrayLeft(this.myArray, length - headSize, headSize, length - headSize - tailSize);
        }
        this.myHead = 0;
        this.myTail = this.mySize % length;
    }

    private static void moveSubArrayLeft(char[] array, int startInd, int length, int moveLeftCount) {
        for (int i = startInd; i < startInd + length; ++i) {
            array[i - moveLeftCount] = array[i];
        }
    }

    private static void reverseSubArray(char[] array, int startInd, int length) {
        for (int i = 0; i < length / 2; ++i) {
            ArrayUtil.swap(array, startInd + i, startInd + length - 1 - i);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/CircularCharBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/CircularCharBuffer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

