/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;

public class ObjectIntCache<K>
implements Iterable {
    public static final int defaultSize = 8192;
    public static final int minSize = 4;
    protected int myTop;
    protected int myBack;
    protected final CacheEntry[] myCache;
    protected final int[] myHashTable;
    protected int myHashTableSize;
    protected int myCount;
    protected int myFirstFree;
    protected final EventDispatcher<DeletedPairsListener> myEventDispatcher = EventDispatcher.create(DeletedPairsListener.class);
    private static final int[] tableSizes = new int[]{5, 11, 23, 47, 101, 199, 397, 797, 1597, 3191, 6397, 12799, 25589, 51199, 102397, 204793, 409579, 819157, 2295859, 4591721, 9183457, 18366923, 36733847, 73467739, 146935499, 293871013, 587742049, 1175484103};
    private long myAttempts;
    private long myHits;

    public ObjectIntCache() {
        this(8192);
    }

    public ObjectIntCache(int cacheSize) {
        int i;
        if (cacheSize < 4) {
            cacheSize = 4;
        }
        this.myBack = 0;
        this.myTop = 0;
        this.myCache = new CacheEntry[cacheSize + 1];
        for (i = 0; i < this.myCache.length; ++i) {
            this.myCache[i] = new CacheEntry();
        }
        this.myHashTableSize = cacheSize;
        i = 0;
        while (this.myHashTableSize > tableSizes[i]) {
            ++i;
        }
        this.myHashTableSize = tableSizes[i];
        this.myHashTable = new int[this.myHashTableSize];
        this.myAttempts = 0L;
        this.myHits = 0L;
        this.myFirstFree = 0;
        this.myCount = 0;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean containsKey(K key) {
        return this.isCached(key);
    }

    public int get(K key) {
        return this.tryKey(key);
    }

    public int put(K key, int value) {
        int oldValue = this.tryKey(key);
        if (oldValue != Integer.MIN_VALUE) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    public void remove(K key) {
        int index2 = this.searchForCacheEntry(key);
        if (index2 != 0) {
            this.removeEntry(index2);
            this.removeEntryFromHashTable(index2);
            this.myCache[index2].hash_next = this.myFirstFree;
            this.myFirstFree = index2;
            this.fireListenersAboutDeletion(index2);
            this.myCache[index2].key = null;
        }
    }

    public void removeAll() {
        ArrayList<Object> keys2 = new ArrayList<Object>(this.count());
        int current = this.myTop;
        while (current > 0) {
            if (this.myCache[current].key != null) {
                keys2.add(this.myCache[current].key);
            }
            current = this.myCache[current].next;
        }
        for (Object e : keys2) {
            this.remove(e);
        }
    }

    public final void cacheObject(K key, int x) {
        int index2 = this.myFirstFree;
        if (this.myCount < this.myCache.length - 1) {
            if (index2 == 0) {
                index2 = this.myCount;
                ++index2;
            } else {
                this.myFirstFree = this.myCache[index2].hash_next;
            }
            if (this.myCount == 0) {
                this.myBack = index2;
            }
        } else {
            index2 = this.myBack;
            this.removeEntryFromHashTable(index2);
            this.fireListenersAboutDeletion(index2);
            this.myBack = this.myCache[index2].prev;
            this.myCache[this.myCache[index2].prev].next = 0;
        }
        this.myCache[index2].key = key;
        this.myCache[index2].value = x;
        this.addEntry2HashTable(index2);
        this.add2Top(index2);
    }

    public final int tryKey(K key) {
        ++this.myAttempts;
        int index2 = this.searchForCacheEntry(key);
        if (index2 == 0) {
            return Integer.MIN_VALUE;
        }
        ++this.myHits;
        if (index2 != this.myTop) {
            this.removeEntry(index2);
            this.add2Top(index2);
        }
        return this.myCache[index2].value;
    }

    public final boolean isCached(K key) {
        return this.searchForCacheEntry(key) != 0;
    }

    public int count() {
        return this.myCount;
    }

    public int size() {
        return this.myCache.length - 1;
    }

    public double hitRate() {
        return this.myAttempts > 0L ? (double)this.myHits / (double)this.myAttempts : 0.0;
    }

    private void add2Top(int index2) {
        this.myCache[index2].next = this.myTop;
        this.myCache[index2].prev = 0;
        this.myCache[this.myTop].prev = index2;
        this.myTop = index2;
    }

    private void removeEntry(int index2) {
        if (index2 == this.myBack) {
            this.myBack = this.myCache[index2].prev;
        } else {
            this.myCache[this.myCache[index2].next].prev = this.myCache[index2].prev;
        }
        if (index2 == this.myTop) {
            this.myTop = this.myCache[index2].next;
        } else {
            this.myCache[this.myCache[index2].prev].next = this.myCache[index2].next;
        }
    }

    private void addEntry2HashTable(int index2) {
        int hash_index = (this.myCache[index2].key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        this.myCache[index2].hash_next = this.myHashTable[hash_index];
        this.myHashTable[hash_index] = index2;
        ++this.myCount;
    }

    private void removeEntryFromHashTable(int index2) {
        int hash_index = (this.myCache[index2].key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        int current = this.myHashTable[hash_index];
        int previous = 0;
        while (current != 0) {
            int next = this.myCache[current].hash_next;
            if (current == index2) {
                if (previous != 0) {
                    this.myCache[previous].hash_next = next;
                } else {
                    this.myHashTable[hash_index] = next;
                }
                --this.myCount;
                break;
            }
            previous = current;
            current = next;
        }
    }

    private int searchForCacheEntry(K key) {
        int index2 = (key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        int current = this.myHashTable[index2];
        this.myCache[0].key = key;
        while (!key.equals(this.myCache[current].key)) {
            current = this.myCache[current].hash_next;
        }
        return current;
    }

    public Iterator iterator() {
        return new ObjectCacheIterator(this);
    }

    public void addDeletedPairsListener(DeletedPairsListener listener) {
        this.myEventDispatcher.addListener(listener);
    }

    public void removeDeletedPairsListener(DeletedPairsListener listener) {
        this.myEventDispatcher.addListener(listener);
    }

    private void fireListenersAboutDeletion(int index2) {
        CacheEntry cacheEntry = this.myCache[index2];
        this.myEventDispatcher.getMulticaster().objectRemoved(cacheEntry.key, cacheEntry.value);
    }

    public static interface DeletedPairsListener
    extends EventListener {
        public void objectRemoved(Object var1, Object var2);
    }

    protected class ObjectCacheIterator<K>
    implements Iterator {
        private final ObjectIntCache<K> myCache;
        private int myCurrentEntry;

        public ObjectCacheIterator(ObjectIntCache<K> cache2) {
            this.myCache = cache2;
            this.myCurrentEntry = 0;
            cache2.myCache[0].next = cache2.myTop;
        }

        @Override
        public boolean hasNext() {
            this.myCurrentEntry = this.myCache.myCache[this.myCurrentEntry].next;
            return this.myCurrentEntry != 0;
        }

        public Object next() {
            return this.myCache.myCache[this.myCurrentEntry].value;
        }

        @Override
        public void remove() {
            this.myCache.remove(this.myCache.myCache[this.myCurrentEntry].key);
        }
    }

    protected static class CacheEntry {
        public Object key;
        public int value;
        public int prev;
        public int next;
        public int hash_next;

        protected CacheEntry() {
        }
    }
}

