/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathInterner {
    private static final TObjectHashingStrategy<SubstringWrapper[]> HASHING_STRATEGY = new TObjectHashingStrategy<SubstringWrapper[]>(){

        @Override
        public int computeHashCode(SubstringWrapper[] object) {
            return Arrays.hashCode(object);
        }

        @Override
        public boolean equals(SubstringWrapper[] o1, SubstringWrapper[] o2) {
            return Arrays.equals(o1, o2);
        }
    };
    private final OpenTHashSet<SubstringWrapper> myInternMap = new OpenTHashSet();

    @Nullable
    protected SubstringWrapper[] internParts(String path2, boolean forAddition) {
        boolean asBytes = forAddition && IOUtil.isAscii(path2);
        ArrayList<SubstringWrapper> key = new ArrayList<SubstringWrapper>();
        SubstringWrapper flyweightKey = new SubstringWrapper();
        for (int start = 0; start < path2.length(); start += flyweightKey.len) {
            flyweightKey.findSubStringUntilNextSeparator(path2, start);
            SubstringWrapper interned = this.myInternMap.get(flyweightKey);
            if (interned == null) {
                if (!forAddition) {
                    return null;
                }
                interned = flyweightKey.createPersistentCopy(asBytes);
                this.myInternMap.add(interned);
            }
            key.add(interned);
        }
        return key.toArray(new SubstringWrapper[key.size()]);
    }

    private static String restorePath(SubstringWrapper[] seq) {
        StringBuilder sb = new StringBuilder();
        for (SubstringWrapper wrapper : seq) {
            wrapper.append(sb);
        }
        return sb.toString();
    }

    static /* synthetic */ TObjectHashingStrategy access$200() {
        return HASHING_STRATEGY;
    }

    public static class PathMap<T> {
        private final THashMap<SubstringWrapper[], T> myMap = new THashMap(PathInterner.access$200());
        private final PathInterner myInterner = new PathInterner();

        @Nullable
        public T get(@NotNull String path2) {
            SubstringWrapper[] seq;
            if (path2 == null) {
                PathMap.$$$reportNull$$$0(0);
            }
            return (seq = this.myInterner.internParts(path2, false)) == null ? null : (T)this.myMap.get(seq);
        }

        public void put(@NotNull String path2, @NotNull T value) {
            if (path2 == null) {
                PathMap.$$$reportNull$$$0(1);
            }
            if (value == null) {
                PathMap.$$$reportNull$$$0(2);
            }
            this.myMap.put(this.myInterner.internParts(path2, true), value);
        }

        public Iterable<T> values() {
            return this.myMap.values();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/PathInterner$PathMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PathEnumerator {
        private final TObjectIntHashMap<SubstringWrapper[]> mySeqToIdx = new TObjectIntHashMap(PathInterner.access$200());
        private final List<SubstringWrapper[]> myIdxToSeq = new ArrayList<SubstringWrapper[]>();
        private final PathInterner myInterner = new PathInterner();

        public PathEnumerator() {
            this.myIdxToSeq.add(null);
        }

        public List<String> getAllPaths() {
            ArrayList<String> result2 = new ArrayList<String>(this.myIdxToSeq.size() - 1);
            for (SubstringWrapper[] wrappers : this.myIdxToSeq) {
                if (wrappers == null) continue;
                result2.add(PathInterner.restorePath(wrappers));
            }
            return result2;
        }

        public int addPath(String path2) {
            SubstringWrapper[] seq = this.myInterner.internParts(path2, true);
            if (!this.mySeqToIdx.containsKey(seq)) {
                this.mySeqToIdx.put(seq, this.myIdxToSeq.size());
                this.myIdxToSeq.add(seq);
            }
            return this.mySeqToIdx.get(seq);
        }

        public String retrievePath(int idx) {
            try {
                return PathInterner.restorePath(this.myIdxToSeq.get(idx));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Illegal index: " + idx);
            }
        }

        public int getExistingPathIndex(String path2) {
            SubstringWrapper[] key = this.myInterner.internParts(path2, false);
            return key != null && this.mySeqToIdx.containsKey(key) ? this.mySeqToIdx.get(key) : 0;
        }

        public boolean containsPath(String path2) {
            SubstringWrapper[] key = this.myInterner.internParts(path2, false);
            return key != null && this.mySeqToIdx.containsKey(key);
        }
    }

    private static class SubstringWrapper {
        private Object encodedString;
        private int start;
        private int len;
        private int hc;

        private SubstringWrapper() {
        }

        void append(StringBuilder sb) {
            if (this.encodedString instanceof String) {
                sb.append(this.encodedString);
                return;
            }
            int oldLen = sb.length();
            sb.setLength(oldLen + this.len);
            byte[] bytes = (byte[])this.encodedString;
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                sb.setCharAt(oldLen + i, (char)bytes[i]);
            }
        }

        void findSubStringUntilNextSeparator(String s, int start) {
            this.encodedString = s;
            this.start = start;
            this.hc = 0;
            while (start < s.length() && SubstringWrapper.isSeparator(s.charAt(start))) {
                this.hc = this.hc * 31 + s.charAt(start);
                ++start;
            }
            while (start < s.length() && !SubstringWrapper.isSeparator(s.charAt(start))) {
                this.hc = this.hc * 31 + s.charAt(start);
                ++start;
            }
            this.len = start - this.start;
        }

        private static boolean isSeparator(char c) {
            return c == '/' || c == '\\' || c == '.' || c == ' ' || c == '_' || c == '$';
        }

        char charAt(int i) {
            if (this.encodedString instanceof String) {
                return ((String)this.encodedString).charAt(this.start + i);
            }
            return (char)((byte[])this.encodedString)[this.start + i];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SubstringWrapper)) {
                return false;
            }
            SubstringWrapper wrapper = (SubstringWrapper)o;
            if (this.hc != wrapper.hc) {
                return false;
            }
            if (this.len != wrapper.len) {
                return false;
            }
            for (int i = 0; i < this.len; ++i) {
                if (this.charAt(i) == wrapper.charAt(i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hc;
        }

        SubstringWrapper createPersistentCopy(boolean asBytes) {
            SubstringWrapper wrapper = new SubstringWrapper();
            String string = (String)this.encodedString;
            String substring = string.substring(this.start, this.start + this.len);
            if (asBytes) {
                byte[] bytes = new byte[this.len];
                for (int i = 0; i < this.len; ++i) {
                    bytes[i] = (byte)string.charAt(i + this.start);
                }
                wrapper.encodedString = bytes;
            } else {
                wrapper.encodedString = string.substring(this.start, this.start + this.len);
            }
            wrapper.start = 0;
            wrapper.len = this.len;
            wrapper.hc = this.hc;
            return wrapper;
        }
    }
}

