/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.LCSBuilder;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.BitSet;

class Reindexer {
    private final int[][] myOldIndecies = new int[2][];
    private final int[] myOriginalLengths = new int[]{-1, -1};
    private final int[] myDiscardedLengths = new int[]{-1, -1};

    Reindexer() {
    }

    public int[][] discardUnique(int[] ints1, int[] ints2) {
        int[] discarded1 = this.discard(ints2, ints1, 0);
        return new int[][]{discarded1, this.discard(discarded1, ints2, 1)};
    }

    void idInit(int length1, int length2) {
        this.myOriginalLengths[0] = length1;
        this.myOriginalLengths[1] = length2;
        this.myDiscardedLengths[0] = length1;
        this.myDiscardedLengths[1] = length2;
        for (int j = 0; j < 2; ++j) {
            int originalLength = this.myOriginalLengths[j];
            this.myOldIndecies[j] = new int[originalLength];
            for (int i = 0; i < originalLength; ++i) {
                this.myOldIndecies[j][i] = i;
            }
        }
    }

    int restoreIndex(int index2, int array) {
        return this.myOldIndecies[array][index2];
    }

    private int[] discard(int[] needed, int[] toDiscard, int arrayIndex) {
        this.myOriginalLengths[arrayIndex] = toDiscard.length;
        int[] sorted1 = this.createSorted(needed);
        TIntArrayList discarded = new TIntArrayList(toDiscard.length);
        TIntArrayList oldIndecies = new TIntArrayList(toDiscard.length);
        for (int i = 0; i < toDiscard.length; ++i) {
            int index2 = toDiscard[i];
            if (Arrays.binarySearch(sorted1, index2) < 0) continue;
            discarded.add(index2);
            oldIndecies.add(i);
        }
        this.myOldIndecies[arrayIndex] = oldIndecies.toNativeArray();
        this.myDiscardedLengths[arrayIndex] = discarded.size();
        return discarded.toNativeArray();
    }

    private int[] createSorted(int[] ints1) {
        int[] sorted1 = new int[ints1.length];
        System.arraycopy(ints1, 0, sorted1, 0, ints1.length);
        Arrays.sort(sorted1);
        return sorted1;
    }

    public void reindex(BitSet[] discardedChanges, LCSBuilder builder) {
        int y;
        int x;
        BitSet changes2;
        BitSet changes1;
        if (this.myDiscardedLengths[0] == this.myOriginalLengths[0] && this.myDiscardedLengths[1] == this.myOriginalLengths[1]) {
            changes1 = discardedChanges[0];
            changes2 = discardedChanges[1];
        } else {
            changes1 = new BitSet(this.myOriginalLengths[0]);
            changes2 = new BitSet(this.myOriginalLengths[1]);
            x = 0;
            y = 0;
            while (x < this.myDiscardedLengths[0] || y < this.myDiscardedLengths[1]) {
                if (x < this.myDiscardedLengths[0] && y < this.myDiscardedLengths[1] && !discardedChanges[0].get(x) && !discardedChanges[1].get(y)) {
                    x = this.increment(this.myOldIndecies[0], x, changes1, this.myOriginalLengths[0]);
                    y = this.increment(this.myOldIndecies[1], y, changes2, this.myOriginalLengths[1]);
                    continue;
                }
                if (discardedChanges[0].get(x)) {
                    changes1.set(this.getOriginal(this.myOldIndecies[0], x));
                    x = this.increment(this.myOldIndecies[0], x, changes1, this.myOriginalLengths[0]);
                    continue;
                }
                if (!discardedChanges[1].get(y)) continue;
                changes2.set(this.getOriginal(this.myOldIndecies[1], y));
                y = this.increment(this.myOldIndecies[1], y, changes2, this.myOriginalLengths[1]);
            }
            if (this.myDiscardedLengths[0] == 0) {
                changes1.set(0, this.myOriginalLengths[0]);
            } else {
                changes1.set(0, this.myOldIndecies[0][0]);
            }
            if (this.myDiscardedLengths[1] == 0) {
                changes2.set(0, this.myOriginalLengths[1]);
            } else {
                changes2.set(0, this.myOldIndecies[1][0]);
            }
        }
        x = 0;
        y = 0;
        while (x < this.myOriginalLengths[0] && y < this.myOriginalLengths[1]) {
            int startX = x;
            while (x < this.myOriginalLengths[0] && y < this.myOriginalLengths[1] && !changes1.get(x) && !changes2.get(y)) {
                ++x;
                ++y;
            }
            if (x > startX) {
                builder.addEqual(x - startX);
            }
            int dx = 0;
            int dy = 0;
            while (x < this.myOriginalLengths[0] && changes1.get(x)) {
                ++dx;
                ++x;
            }
            while (y < this.myOriginalLengths[1] && changes2.get(y)) {
                ++dy;
                ++y;
            }
            if (dx == 0 && dy == 0) continue;
            builder.addChange(dx, dy);
        }
        if (x != this.myOriginalLengths[0] || y != this.myOriginalLengths[1]) {
            builder.addChange(this.myOriginalLengths[0] - x, this.myOriginalLengths[1] - y);
        }
    }

    private int getOriginal(int[] indexes, int i) {
        return indexes[i];
    }

    private int increment(int[] indexes, int i, BitSet set, int length) {
        if (i + 1 < indexes.length) {
            set.set(indexes[i] + 1, indexes[i + 1]);
        } else {
            set.set(indexes[i] + 1, length);
        }
        return i + 1;
    }
}

