/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import gnu.trove.THashMap;
import gnu.trove.TIntIntHashMap;
import java.util.Map;

public class IdDataConsumer {
    private final TIntIntHashMap myResult = new TIntIntHashMap();

    public Map<IdIndexEntry, Integer> getResult() {
        THashMap<IdIndexEntry, Integer> result2 = new THashMap<IdIndexEntry, Integer>(this.myResult.size());
        this.myResult.forEachEntry((key, value) -> {
            result2.put(new IdIndexEntry(key), value);
            return true;
        });
        return result2;
    }

    public void addOccurrence(CharSequence charSequence, int start, int end, int occurrenceMask) {
        int hashCode2 = StringUtil.stringHashCode(charSequence, start, end);
        this.addOccurrence(hashCode2, occurrenceMask);
        int hashCodeNoCase = StringUtil.stringHashCodeInsensitive(charSequence, start, end);
        if (hashCodeNoCase != hashCode2) {
            this.addOccurrence(hashCodeNoCase, occurrenceMask);
        }
    }

    public void addOccurrence(char[] chars, int start, int end, int occurrenceMask) {
        int hashCode2 = StringUtil.stringHashCode(chars, start, end);
        this.addOccurrence(hashCode2, occurrenceMask);
        int hashCodeNoCase = StringUtil.stringHashCodeInsensitive(chars, start, end);
        if (hashCodeNoCase != hashCode2) {
            this.addOccurrence(hashCodeNoCase, occurrenceMask);
        }
    }

    private void addOccurrence(int hashcode, int occurrenceMask) {
        int old;
        int v;
        if (occurrenceMask != 0 && (v = (old = this.myResult.get(hashcode)) | occurrenceMask) != old) {
            this.myResult.put(hashcode, v);
        }
    }
}

