/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class IndexableSetContributor {
    public static final ExtensionPointName<IndexableSetContributor> EP_NAME = new ExtensionPointName("com.intellij.indexedRootsProvider");
    private static final Logger LOG = Logger.getInstance(IndexableSetContributor.class);

    @NotNull
    public static Set<VirtualFile> getProjectRootsToIndex(@NotNull IndexableSetContributor contributor, @NotNull Project project) {
        if (contributor == null) {
            IndexableSetContributor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            IndexableSetContributor.$$$reportNull$$$0(1);
        }
        Set<VirtualFile> roots2 = contributor.getAdditionalProjectRootsToIndex(project);
        Set<VirtualFile> set = IndexableSetContributor.filterOutNulls(contributor, "getAdditionalProjectRootsToIndex(Project)", roots2);
        if (set == null) {
            IndexableSetContributor.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getRootsToIndex(@NotNull IndexableSetContributor contributor) {
        if (contributor == null) {
            IndexableSetContributor.$$$reportNull$$$0(3);
        }
        Set<VirtualFile> roots2 = contributor.getAdditionalRootsToIndex();
        Set<VirtualFile> set = IndexableSetContributor.filterOutNulls(contributor, "getAdditionalRootsToIndex()", roots2);
        if (set == null) {
            IndexableSetContributor.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        if (project == null) {
            IndexableSetContributor.$$$reportNull$$$0(5);
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            IndexableSetContributor.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public abstract Set<VirtualFile> getAdditionalRootsToIndex();

    @NotNull
    private static Set<VirtualFile> filterOutNulls(@NotNull IndexableSetContributor contributor, @NotNull String methodInfo, @NotNull Set<VirtualFile> roots2) {
        if (contributor == null) {
            IndexableSetContributor.$$$reportNull$$$0(7);
        }
        if (methodInfo == null) {
            IndexableSetContributor.$$$reportNull$$$0(8);
        }
        if (roots2 == null) {
            IndexableSetContributor.$$$reportNull$$$0(9);
        }
        for (VirtualFile root2 : roots2) {
            if (root2 != null && root2.isValid()) continue;
            LOG.error("Please fix " + contributor.getClass().getName() + "#" + methodInfo + ".\n" + (root2 == null ? "The returned set is not expected to contain nulls, but it is " + roots2 : "Invalid file returned: " + root2));
            LinkedHashSet<VirtualFile> linkedHashSet = ContainerUtil.newLinkedHashSet(ContainerUtil.filter(roots2, virtualFile2 -> virtualFile2 != null && virtualFile2.isValid()));
            if (linkedHashSet == null) {
                IndexableSetContributor.$$$reportNull$$$0(10);
            }
            return linkedHashSet;
        }
        Set<VirtualFile> set = roots2;
        if (set == null) {
            IndexableSetContributor.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexableSetContributor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexableSetContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRootsToIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectRootsToIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutNulls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRootsToIndex";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectRootsToIndex";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterOutNulls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

