/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.Computable;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.FileId2ValueMapping;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTrackingValueContainer<Value>
extends UpdatableValueContainer<Value> {
    private ValueContainerImpl<Value> myAdded;
    private TIntHashSet myInvalidated;
    private volatile ValueContainerImpl<Value> myMerged;
    private final Initializer<Value> myInitializer;

    public ChangeTrackingValueContainer(Initializer<Value> initializer2) {
        this.myInitializer = initializer2;
    }

    @Override
    public void addValue(int inputId, Value value) {
        ValueContainerImpl<Value> merged = this.myMerged;
        if (merged != null) {
            merged.addValue(inputId, value);
        }
        if (this.myAdded == null) {
            this.myAdded = new ValueContainerImpl();
        }
        this.myAdded.addValue(inputId, value);
    }

    @Override
    public void removeAssociatedValue(int inputId) {
        ValueContainerImpl<Value> merged = this.myMerged;
        if (merged != null) {
            merged.removeAssociatedValue(inputId);
        }
        if (this.myAdded != null) {
            this.myAdded.removeAssociatedValue(inputId);
        }
        if (this.myInvalidated == null) {
            this.myInvalidated = new TIntHashSet(1);
        }
        this.myInvalidated.add(inputId);
    }

    @Override
    public int size() {
        return this.getMergedData().size();
    }

    @Override
    @NotNull
    public ValueContainer.ValueIterator<Value> getValueIterator() {
        ValueContainer.ValueIterator valueIterator = this.getMergedData().getValueIterator();
        if (valueIterator == null) {
            ChangeTrackingValueContainer.$$$reportNull$$$0(0);
        }
        return valueIterator;
    }

    public void dropMergedData() {
        this.myMerged = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueContainerImpl<Value> getMergedData() {
        ValueContainerImpl<Value> merged = this.myMerged;
        if (merged != null) {
            return merged;
        }
        Object object = this.myInitializer.getLock();
        synchronized (object) {
            merged = this.myMerged;
            if (merged != null) {
                return merged;
            }
            FileId2ValueMapping fileId2ValueMapping = null;
            ValueContainer fromDisk = (ValueContainer)this.myInitializer.compute();
            Object newMerged = fromDisk instanceof ValueContainerImpl ? ((ValueContainerImpl)fromDisk).clone() : ((ChangeTrackingValueContainer)fromDisk).getMergedData().clone();
            if ((this.myAdded != null || this.myInvalidated != null) && (((ValueContainerImpl)newMerged).size() > 20 || this.myAdded != null && this.myAdded.size() > 20)) {
                fileId2ValueMapping = new FileId2ValueMapping(newMerged);
            }
            final FileId2ValueMapping finalFileId2ValueMapping = fileId2ValueMapping;
            if (this.myInvalidated != null) {
                this.myInvalidated.forEach(new TIntProcedure((ValueContainerImpl)newMerged){
                    final /* synthetic */ ValueContainerImpl val$newMerged;
                    {
                        this.val$newMerged = valueContainerImpl;
                    }

                    @Override
                    public boolean execute(int inputId) {
                        if (finalFileId2ValueMapping != null) {
                            finalFileId2ValueMapping.removeFileId(inputId);
                        } else {
                            this.val$newMerged.removeAssociatedValue(inputId);
                        }
                        return true;
                    }
                });
            }
            if (this.myAdded != null) {
                if (fileId2ValueMapping != null) {
                    fileId2ValueMapping.disableOneValuePerFileValidation();
                }
                this.myAdded.forEach(new ValueContainer.ContainerAction<Value>((ValueContainerImpl)newMerged){
                    final /* synthetic */ ValueContainerImpl val$newMerged;
                    {
                        this.val$newMerged = valueContainerImpl;
                    }

                    @Override
                    public boolean perform(int inputId, Value value) {
                        if (finalFileId2ValueMapping != null) {
                            finalFileId2ValueMapping.removeFileId(inputId);
                        } else {
                            this.val$newMerged.removeAssociatedValue(inputId);
                        }
                        this.val$newMerged.addValue(inputId, value);
                        if (finalFileId2ValueMapping != null) {
                            finalFileId2ValueMapping.associateFileIdToValue(inputId, value);
                        }
                        return true;
                    }
                });
            }
            this.setNeedsCompacting(((UpdatableValueContainer)fromDisk).needsCompacting());
            this.myMerged = newMerged;
            return newMerged;
        }
    }

    public boolean isDirty() {
        return this.myAdded != null && this.myAdded.size() > 0 || this.myInvalidated != null && !this.myInvalidated.isEmpty() || this.needsCompacting();
    }

    @Nullable
    public UpdatableValueContainer<Value> getAddedDelta() {
        return this.myAdded;
    }

    @Override
    public void saveTo(DataOutput out, DataExternalizer<Value> externalizer) throws IOException {
        if (this.needsCompacting()) {
            this.getMergedData().saveTo(out, externalizer);
        } else {
            UpdatableValueContainer<Value> toAppend;
            TIntHashSet set = this.myInvalidated;
            if (set != null && set.size() > 0) {
                for (int inputId : set.toArray()) {
                    DataInputOutputUtil.writeINT(out, -inputId);
                }
            }
            if ((toAppend = this.getAddedDelta()) != null && toAppend.size() > 0) {
                toAppend.saveTo(out, externalizer);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ChangeTrackingValueContainer", "getValueIterator"));
    }

    public static interface Initializer<T>
    extends Computable<ValueContainer<T>> {
        public Object getLock();
    }
}

