/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.indexing.impl.MapReduceIndex");
    @NotNull
    protected final IndexId<Key, Value> myIndexId;
    @NotNull
    protected final IndexStorage<Key, Value> myStorage;
    protected final DataExternalizer<Value> myValueExternalizer;
    protected final IndexExtension<Key, Value, Input> myExtension;
    private final AtomicLong myModificationStamp;
    private final DataIndexer<Key, Value, Input> myIndexer;
    protected final ForwardIndex<Key, Value> myForwardIndex;
    private final ReentrantReadWriteLock myLock;
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private final RemovedKeyProcessor<Key> myRemovedKeyProcessor;
    private final KeyValueUpdateProcessor<Key, Value> myAddedKeyProcessor;
    private final KeyValueUpdateProcessor<Key, Value> myUpdatedKeyProcessor;

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2, ForwardIndex<Key, Value> forwardIndex) {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            MapReduceIndex.$$$reportNull$$$0(1);
        }
        this.myModificationStamp = new AtomicLong();
        this.myLock = this.createLock();
        this.myLowMemoryFlusher = LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                try {
                    MapReduceIndex.this.getReadLock().lock();
                    try {
                        MapReduceIndex.this.myStorage.clearCaches();
                    }
                    finally {
                        MapReduceIndex.this.getReadLock().unlock();
                    }
                    MapReduceIndex.this.flush();
                }
                catch (Throwable e) {
                    MapReduceIndex.this.requestRebuild(e);
                }
            }
        });
        this.myRemovedKeyProcessor = new RemovedKeyProcessor<Key>(){

            @Override
            public void process(Key key, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
            }
        };
        this.myAddedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
            }
        };
        this.myUpdatedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
            }
        };
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = storage2;
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myForwardIndex = forwardIndex;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            MapReduceIndex.$$$reportNull$$$0(2);
        }
        return indexStorage;
    }

    @NotNull
    protected ReentrantReadWriteLock createLock() {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        if (reentrantReadWriteLock == null) {
            MapReduceIndex.$$$reportNull$$$0(3);
        }
        return reentrantReadWriteLock;
    }

    public final ReentrantReadWriteLock getLock() {
        return this.myLock;
    }

    @Override
    public void clear() {
        try {
            this.getWriteLock().lock();
            this.doClear();
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        catch (IOException e) {
            LOG.error(e);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected void doClear() throws StorageException, IOException {
        this.myStorage.clear();
        if (this.myForwardIndex != null) {
            this.myForwardIndex.clear();
        }
    }

    @Override
    public void flush() throws StorageException {
        try {
            this.getReadLock().lock();
            this.doFlush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    protected void doFlush() throws IOException, StorageException {
        if (this.myForwardIndex != null) {
            this.myForwardIndex.flush();
        }
        this.myStorage.flush();
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        Lock lock = this.getWriteLock();
        try {
            lock.lock();
            this.doDispose();
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        finally {
            this.myDisposed = true;
            lock.unlock();
        }
    }

    protected void doDispose() throws StorageException {
        try {
            this.myStorage.close();
        }
        finally {
            try {
                if (this.myForwardIndex != null) {
                    this.myForwardIndex.close();
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public final Lock getReadLock() {
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        if (readLock == null) {
            MapReduceIndex.$$$reportNull$$$0(4);
        }
        return readLock;
    }

    @NotNull
    public final Lock getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (writeLock == null) {
            MapReduceIndex.$$$reportNull$$$0(5);
        }
        return writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            MapReduceIndex.$$$reportNull$$$0(6);
        }
        Lock lock = this.getReadLock();
        lock.lock();
        if (this.myDisposed) {
            ValueContainerImpl valueContainerImpl = new ValueContainerImpl();
            ValueContainerImpl valueContainerImpl2 = valueContainerImpl;
            if (valueContainerImpl2 == null) {
                MapReduceIndex.$$$reportNull$$$0(7);
            }
            return valueContainerImpl2;
        }
        ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
        ValueContainer<Value> valueContainer = this.myStorage.read(key);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            MapReduceIndex.$$$reportNull$$$0(8);
        }
        return valueContainer2;
        finally {
            ValueContainerImpl.ourDebugIndexInfo.set(null);
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public final Computable<Boolean> update(final int inputId, @Nullable Input content2) {
        final UpdateData<Key, Value> updateData = this.calculateUpdateData(inputId, content2);
        Computable<Boolean> computable = new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                try {
                    MapReduceIndex.this.updateWithMap(inputId, updateData);
                }
                catch (StorageException ex) {
                    LOG.info("Exception during updateWithMap:" + ex);
                    MapReduceIndex.this.requestRebuild(ex);
                    return Boolean.FALSE;
                }
                catch (ProcessCanceledException ex) {
                    LOG.info("Exception during updateWithMap:" + ex);
                    MapReduceIndex.this.requestRebuild(ex);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
        if (computable == null) {
            MapReduceIndex.$$$reportNull$$$0(9);
        }
        return computable;
    }

    @NotNull
    protected UpdateData<Key, Value> calculateUpdateData(final int inputId, @Nullable Input content2) {
        final Map<Key, Value> data2 = this.mapInput(content2);
        UpdateData<Key, Value> updateData = this.createUpdateData(data2, new ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException>(){

            @Override
            public InputDataDiffBuilder<Key, Value> compute() throws IOException {
                return MapReduceIndex.this.getKeysDiffBuilder(inputId);
            }
        }, new ThrowableRunnable<IOException>(){

            @Override
            public void run() throws IOException {
                if (MapReduceIndex.this.myForwardIndex != null) {
                    MapReduceIndex.this.myForwardIndex.putInputData(inputId, data2);
                }
            }
        });
        if (updateData == null) {
            MapReduceIndex.$$$reportNull$$$0(10);
        }
        return updateData;
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.myForwardIndex != null) {
            InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.myForwardIndex.getDiffBuilder(inputId);
            if (inputDataDiffBuilder == null) {
                MapReduceIndex.$$$reportNull$$$0(11);
            }
            return inputDataDiffBuilder;
        }
        EmptyInputDataDiffBuilder emptyInputDataDiffBuilder = new EmptyInputDataDiffBuilder(inputId);
        if (emptyInputDataDiffBuilder == null) {
            MapReduceIndex.$$$reportNull$$$0(12);
        }
        return emptyInputDataDiffBuilder;
    }

    @NotNull
    protected UpdateData<Key, Value> createUpdateData(Map<Key, Value> data2, ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> keys2, ThrowableRunnable<IOException> forwardIndexUpdate) {
        UpdateData<Key, Value> updateData = new UpdateData<Key, Value>(data2, keys2, this.myIndexId, forwardIndexUpdate);
        if (updateData == null) {
            MapReduceIndex.$$$reportNull$$$0(13);
        }
        return updateData;
    }

    protected Map<Key, Value> mapInput(Input content2) {
        if (content2 == null) {
            return Collections.emptyMap();
        }
        Map<Key, Value> data2 = this.myIndexer.map(content2);
        MapReduceIndex.checkValuesHaveProperEqualsAndHashCode(data2, this.myIndexId, this.myValueExternalizer);
        this.checkCanceled();
        return data2;
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(Throwable var1);

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWithMap(int inputId, @NotNull UpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            MapReduceIndex.$$$reportNull$$$0(14);
        }
        this.getWriteLock().lock();
        try {
            try {
                ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
                updateData.iterateKeys(this.myAddedKeyProcessor, this.myUpdatedKeyProcessor, this.myRemovedKeyProcessor);
                updateData.updateForwardIndex();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
            finally {
                ValueContainerImpl.ourDebugIndexInfo.set(null);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public static <Key, Value> void checkValuesHaveProperEqualsAndHashCode(@NotNull Map<Key, Value> data2, @NotNull IndexId<Key, Value> indexId, @NotNull DataExternalizer<Value> valueExternalizer) {
        if (data2 == null) {
            MapReduceIndex.$$$reportNull$$$0(15);
        }
        if (indexId == null) {
            MapReduceIndex.$$$reportNull$$$0(16);
        }
        if (valueExternalizer == null) {
            MapReduceIndex.$$$reportNull$$$0(17);
        }
        if (DebugAssertions.DEBUG) {
            for (Map.Entry<Key, Value> e : data2.entrySet()) {
                Value value = e.getValue();
                if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                    LOG.error("Index " + indexId + " violates equals / hashCode contract for Value parameter");
                }
                try {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    DataOutputStream outputStream2 = new DataOutputStream(out);
                    valueExternalizer.save(outputStream2, value);
                    outputStream2.close();
                    Value deserializedValue = valueExternalizer.read(new DataInputStream(new UnsyncByteArrayInputStream(out.getInternalBuffer(), 0, out.size())));
                    if (Comparing.equal(value, deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                    LOG.error("Index " + indexId + " deserialization violates equals / hashCode contract for Value parameter");
                }
                catch (IOException ex) {
                    LOG.error(ex);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadLock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriteLock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateUpdateData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkValuesHaveProperEqualsAndHashCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

