/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public abstract class BinaryOutputReader
extends BaseDataReader {
    @NotNull
    private final InputStream myStream;
    @NotNull
    private final byte[] myBuffer;

    public BinaryOutputReader(@NotNull InputStream stream2, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (stream2 == null) {
            BinaryOutputReader.$$$reportNull$$$0(0);
        }
        if (sleepingPolicy == null) {
            BinaryOutputReader.$$$reportNull$$$0(1);
        }
        super(sleepingPolicy);
        this.myBuffer = new byte[8192];
        this.myStream = stream2;
    }

    @Override
    protected boolean readAvailableNonBlocking() throws IOException {
        int n;
        byte[] buffer = this.myBuffer;
        boolean read2 = false;
        while (this.myStream.available() > 0 && (n = this.myStream.read(buffer)) >= 0) {
            if (n <= 0) continue;
            read2 = true;
            this.onBinaryAvailable(buffer, n);
        }
        return read2;
    }

    @Override
    protected final boolean readAvailableBlocking() throws IOException {
        int n;
        byte[] buffer = this.myBuffer;
        boolean read2 = false;
        while ((n = this.myStream.read(buffer)) >= 0) {
            if (n <= 0) continue;
            read2 = true;
            this.onBinaryAvailable(buffer, n);
        }
        return read2;
    }

    protected abstract void onBinaryAvailable(@NotNull byte[] var1, int var2);

    @Override
    protected void close() throws IOException {
        this.myStream.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "stream";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sleepingPolicy";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/BinaryOutputReader";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

