/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SmartList;
import com.intellij.util.io.CharSequenceBackedByChars;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\n\u00a8\u0006\u000b"}, d2={"decodeBase64", "", "", "encodeUrlQueryParameter", "readCharSequence", "", "Ljava/io/InputStreamReader;", "length", "", "toByteArray", "Ljava/nio/ByteBuffer;", "projectModel-api"})
public final class IoKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readCharSequence(@NotNull InputStreamReader $receiver, int length) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Closeable closeable = $receiver;
        Throwable throwable = null;
        try {
            int count2;
            int n;
            InputStreamReader it = (InputStreamReader)closeable;
            char[] chars = new char[length];
            for (count2 = 0; count2 < chars.length && (n = $receiver.read(chars, count2, chars.length - count2)) > 0; count2 += n) {
            }
            CharSequence charSequence = new CharSequenceBackedByChars(chars, 0, count2);
            return charSequence;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @NotNull
    public static final CharSequence readCharSequence(@NotNull InputStreamReader $receiver) {
        int n;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        char[] chars = new char[8192];
        List buffers = null;
        int count2 = 0;
        int total = 0;
        while ((n = $receiver.read(chars, count2, chars.length - count2)) > 0) {
            total += n;
            if ((count2 += n) != chars.length) continue;
            if (buffers == null) {
                buffers = new SmartList();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count2 = 0;
        }
        if (buffers == null) {
            return new CharSequenceBackedByChars(chars, 0, total);
        }
        char[] result2 = new char[total];
        for (char[] buffer : buffers) {
            System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
            total -= buffer.length;
        }
        System.arraycopy(chars, 0, result2, result2.length - total, total);
        return new CharSequenceBackedByChars(result2);
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.hasArray()) {
            int offset2 = $receiver.arrayOffset();
            if (offset2 == 0 && $receiver.array().length == $receiver.limit()) {
                byte[] byArray = $receiver.array();
                Intrinsics.checkExpressionValueIsNotNull(byArray, "array()");
                return byArray;
            }
            byte[] byArray = Arrays.copyOfRange($receiver.array(), offset2, offset2 + $receiver.limit());
            Intrinsics.checkExpressionValueIsNotNull(byArray, "Arrays.copyOfRange(array\u2026offset, offset + limit())");
            return byArray;
        }
        byte[] bytes = new byte[$receiver.limit()];
        $receiver.get(bytes);
        return bytes;
    }

    @NotNull
    public static final String encodeUrlQueryParameter(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String string = URLEncoder.encode($receiver, Charsets.UTF_8.name());
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        byte[] byArray = Base64.getDecoder().decode($receiver);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "Base64.getDecoder().decode(this)");
        return byArray;
    }
}

