/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.ByteBufferWrapper;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOStatistics;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public abstract class MappedBufferWrapper
extends ByteBufferWrapper {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.MappedBufferWrapper");
    private static final int MAX_FORCE_ATTEMPTS = 10;
    private volatile MappedByteBuffer myBuffer;

    protected MappedBufferWrapper(File file2, long pos, long length) {
        super(file2, pos, length);
    }

    protected abstract MappedByteBuffer map() throws IOException;

    @Override
    public final void unmap() {
        long finished;
        long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        MappedByteBuffer buffer = this.myBuffer;
        this.myBuffer = null;
        if (!MappedBufferWrapper.clean(buffer, this.isDirty())) {
            LOG.error("Unmapping failed for: " + this.myFile);
        }
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Unmapped " + this.myFile + "," + this.myPosition + "," + this.myLength + " for " + (finished - started));
        }
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        MappedByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.map();
        }
        return buffer;
    }

    private static boolean clean(MappedByteBuffer buffer, boolean dirty) {
        if (buffer == null) {
            return true;
        }
        if (dirty && !MappedBufferWrapper.tryForce(buffer)) {
            return false;
        }
        return DirectBufferWrapper.disposeDirectBuffer(buffer);
    }

    private static boolean tryForce(MappedByteBuffer buffer) {
        for (int i = 0; i < 10; ++i) {
            try {
                buffer.force();
                return true;
            }
            catch (Throwable e) {
                LOG.info(e);
                TimeoutUtil.sleep(10L);
                continue;
            }
        }
        return false;
    }

    @Override
    public void flush() {
        MappedByteBuffer buffer = this.myBuffer;
        if (buffer != null && this.isDirty() && MappedBufferWrapper.tryForce(buffer)) {
            this.myDirty = false;
        }
    }
}

