/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class ReplicatorInputStream
extends InputStream {
    private final BufferExposingByteArrayOutputStream myTarget;
    private final InputStream mySource;
    private int markedSize;

    public ReplicatorInputStream(InputStream source, BufferExposingByteArrayOutputStream target) {
        this.mySource = source;
        this.myTarget = target;
    }

    @Override
    public int read() throws IOException {
        int b = this.mySource.read();
        if (b == -1) {
            return -1;
        }
        this.myTarget.write(b);
        return b;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mySource.mark(readlimit);
        this.markedSize = this.myTarget.size();
    }

    @Override
    public boolean markSupported() {
        return this.mySource.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.mySource.reset();
        this.myTarget.backOff(this.myTarget.size() - this.markedSize);
        this.markedSize = 0;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        if (b == null) {
            ReplicatorInputStream.$$$reportNull$$$0(0);
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int count2;
        if (b == null) {
            ReplicatorInputStream.$$$reportNull$$$0(1);
        }
        if ((count2 = this.mySource.read(b, off, len)) < 0) {
            return count2;
        }
        this.myTarget.write(b, off, count2);
        return count2;
    }

    @Override
    public long skip(long n) throws IOException {
        int skipped = this.read(new byte[(int)n]);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.mySource.available();
    }

    @Override
    public void close() throws IOException {
        this.mySource.close();
        this.myTarget.close();
    }

    public int getBytesRead() {
        return this.myTarget.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/ReplicatorInputStream", "read"));
    }
}

