/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.RefCountingRecordsTable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.NotNull;

public class RefCountingStorage
extends AbstractStorage {
    private final Map<Integer, Future<?>> myPendingWriteRequests = ContainerUtil.newConcurrentMap();
    private int myPendingWriteRequestsSize;
    private final ExecutorService myPendingWriteRequestsExecutor = this.createExecutor();
    private final boolean myDoNotZipCaches;
    private static final int MAX_PENDING_WRITE_SIZE = 0x1400000;

    @NotNull
    protected ExecutorService createExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory("RefCountingStorage write content helper"));
        if (threadPoolExecutor == null) {
            RefCountingStorage.$$$reportNull$$$0(0);
        }
        return threadPoolExecutor;
    }

    public RefCountingStorage(String path2) throws IOException {
        this(path2, CapacityAllocationPolicy.DEFAULT);
    }

    public RefCountingStorage(String path2, CapacityAllocationPolicy capacityAllocationPolicy) throws IOException {
        this(path2, capacityAllocationPolicy, Boolean.valueOf(System.getProperty("idea.doNotZipCaches")));
    }

    public RefCountingStorage(String path2, CapacityAllocationPolicy capacityAllocationPolicy, boolean doNotZipCaches) throws IOException {
        super(path2, capacityAllocationPolicy);
        this.myDoNotZipCaches = doNotZipCaches;
    }

    @Override
    public DataInputStream readStream(int record2) throws IOException {
        if (this.myDoNotZipCaches) {
            return super.readStream(record2);
        }
        BufferExposingByteArrayOutputStream stream2 = this.internalReadStream(record2);
        return new DataInputStream(new UnsyncByteArrayInputStream(stream2.getInternalBuffer(), 0, stream2.size()));
    }

    @Override
    protected byte[] readBytes(int record2) throws IOException {
        if (this.myDoNotZipCaches) {
            return super.readBytes(record2);
        }
        return this.internalReadStream(record2).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferExposingByteArrayOutputStream internalReadStream(int record2) throws IOException {
        byte[] result2;
        this.waitForPendingWriteForRecord(record2);
        Object object = this.myLock;
        synchronized (object) {
            result2 = super.readBytes(record2);
        }
        CustomInflaterInputStream in = new CustomInflaterInputStream(result2);
        try {
            BufferExposingByteArrayOutputStream outputStream2 = new BufferExposingByteArrayOutputStream();
            StreamUtil.copyStreamContent(in, outputStream2);
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = outputStream2;
            return bufferExposingByteArrayOutputStream;
        }
        finally {
            ((InflaterInputStream)in).close();
        }
    }

    private void waitForPendingWriteForRecord(int record2) {
        Future<?> future = this.myPendingWriteRequests.get(record2);
        if (future != null) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void appendBytes(int record2, ByteSequence bytes) throws IOException {
        throw new IncorrectOperationException("Appending is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(final int record2, final ByteSequence bytes, final boolean fixedSize) throws IOException {
        if (this.myDoNotZipCaches) {
            super.writeBytes(record2, bytes, fixedSize);
            return;
        }
        this.waitForPendingWriteForRecord(record2);
        Object object = this.myLock;
        synchronized (object) {
            this.myPendingWriteRequestsSize += bytes.getLength();
            if (this.myPendingWriteRequestsSize > 0x1400000) {
                this.zipAndWrite(bytes, record2, fixedSize);
            } else {
                this.myPendingWriteRequests.put(record2, this.myPendingWriteRequestsExecutor.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws IOException {
                        RefCountingStorage.this.zipAndWrite(bytes, record2, fixedSize);
                        return null;
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipAndWrite(ByteSequence bytes, int record2, boolean fixedSize) throws IOException {
        BufferExposingByteArrayOutputStream s = new BufferExposingByteArrayOutputStream();
        DeflaterOutputStream out = new DeflaterOutputStream(s);
        try {
            out.write(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
        }
        finally {
            out.close();
        }
        Object object = this.myLock;
        synchronized (object) {
            this.doWrite(record2, fixedSize, s);
            this.myPendingWriteRequestsSize -= bytes.getLength();
            this.myPendingWriteRequests.remove(record2);
        }
    }

    private void doWrite(int record2, boolean fixedSize, BufferExposingByteArrayOutputStream s) throws IOException {
        super.writeBytes(record2, new ByteSequence(s.getInternalBuffer(), 0, s.size()), fixedSize);
    }

    @Override
    protected AbstractRecordsTable createRecordsTable(PagePool pool, File recordsFile) throws IOException {
        return new RefCountingRecordsTable(recordsFile, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquireNewRecord() throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            int record2 = this.myRecordsTable.createNewRecord();
            ((RefCountingRecordsTable)this.myRecordsTable).incRefCount(record2);
            return record2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createNewRecord() throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            return this.myRecordsTable.createNewRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRecord(int record2) {
        this.waitForPendingWriteForRecord(record2);
        Object object = this.myLock;
        synchronized (object) {
            ((RefCountingRecordsTable)this.myRecordsTable).incRefCount(record2);
        }
    }

    public void releaseRecord(int record2) throws IOException {
        this.releaseRecord(record2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRecord(int record2, boolean completely) throws IOException {
        this.waitForPendingWriteForRecord(record2);
        Object object = this.myLock;
        synchronized (object) {
            if (((RefCountingRecordsTable)this.myRecordsTable).decRefCount(record2) && completely) {
                this.doDeleteRecord(record2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefCount(int record2) {
        this.waitForPendingWriteForRecord(record2);
        Object object = this.myLock;
        synchronized (object) {
            return ((RefCountingRecordsTable)this.myRecordsTable).getRefCount(record2);
        }
    }

    @Override
    public void force() {
        this.flushPendingWrites();
        super.force();
    }

    @Override
    public boolean isDirty() {
        return !this.myPendingWriteRequests.isEmpty() || super.isDirty();
    }

    @Override
    public boolean flushSome() {
        this.flushPendingWrites();
        return super.flushSome();
    }

    @Override
    public void dispose() {
        this.flushPendingWrites();
        super.dispose();
    }

    @Override
    public void checkSanity(int record2) {
        this.flushPendingWrites();
        super.checkSanity(record2);
    }

    private void flushPendingWrites() {
        for (Map.Entry<Integer, Future<?>> entry : this.myPendingWriteRequests.entrySet()) {
            try {
                entry.getValue().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/storage/RefCountingStorage", "createExecutor"));
    }

    private static class CustomInflaterInputStream
    extends InflaterInputStream {
        public CustomInflaterInputStream(byte[] compressedData) {
            super(new UnsyncByteArrayInputStream(compressedData), new Inflater(), 1);
            this.buf = compressedData;
            this.len = -1;
        }

        @Override
        protected void fill() throws IOException {
            if (this.len >= 0) {
                throw new EOFException();
            }
            this.len = this.buf.length;
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.inf.end();
        }
    }
}

