/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.tar;

class TarUtils {
    private static final int BYTE_MASK = 255;

    TarUtils() {
    }

    public static long parseOctal(byte[] header, int offset2, int length) {
        long result2 = 0L;
        boolean stillPadding = true;
        int end = offset2 + length;
        for (int i = offset2; i < end && header[i] != 0; ++i) {
            if (header[i] == 32 || header[i] == 48) {
                if (stillPadding) continue;
                if (header[i] == 32) break;
            }
            stillPadding = false;
            result2 = (result2 << 3) + (long)(header[i] - 48);
        }
        return result2;
    }

    public static StringBuffer parseName(byte[] header, int offset2, int length) {
        StringBuffer result2 = new StringBuffer(length);
        int end = offset2 + length;
        for (int i = offset2; i < end && header[i] != 0; ++i) {
            result2.append((char)header[i]);
        }
        return result2;
    }

    public static int getNameBytes(StringBuffer name, byte[] buf, int offset2, int length) {
        int i;
        for (i = 0; i < length && i < name.length(); ++i) {
            buf[offset2 + i] = (byte)name.charAt(i);
        }
        while (i < length) {
            buf[offset2 + i] = 0;
            ++i;
        }
        return offset2 + length;
    }

    public static int getOctalBytes(long value, byte[] buf, int offset2, int length) {
        int idx = length - 1;
        buf[offset2 + idx] = 0;
        buf[offset2 + --idx] = 32;
        --idx;
        if (value == 0L) {
            buf[offset2 + idx] = 48;
            --idx;
        } else {
            for (long val = value; idx >= 0 && val > 0L; val >>= 3, --idx) {
                buf[offset2 + idx] = (byte)(48 + (byte)(val & 7L));
            }
        }
        while (idx >= 0) {
            buf[offset2 + idx] = 32;
            --idx;
        }
        return offset2 + length;
    }

    public static int getLongOctalBytes(long value, byte[] buf, int offset2, int length) {
        byte[] temp = new byte[length + 1];
        TarUtils.getOctalBytes(value, temp, 0, length + 1);
        System.arraycopy(temp, 0, buf, offset2, length);
        return offset2 + length;
    }

    public static int getCheckSumOctalBytes(long value, byte[] buf, int offset2, int length) {
        TarUtils.getOctalBytes(value, buf, offset2, length);
        buf[offset2 + length - 1] = 32;
        buf[offset2 + length - 2] = 0;
        return offset2 + length;
    }

    public static long computeCheckSum(byte[] buf) {
        long sum = 0L;
        for (int i = 0; i < buf.length; ++i) {
            sum += (long)(0xFF & buf[i]);
        }
        return sum;
    }
}

