/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.zip.DosTime;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import com.intellij.util.io.zip.ZipLong;
import com.intellij.util.io.zip.ZipShort;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;
import org.jetbrains.annotations.NotNull;

class JBZipOutputStream {
    public static final int DEFAULT_COMPRESSION = -1;
    private String comment = "";
    private int level = -1;
    private int method = 0;
    private final CRC32 crc = new CRC32();
    private long writtenOnDisk = 0L;
    private String encoding = null;
    private final Deflater def = new Deflater(this.level, true);
    private final RandomAccessFile raf;
    private final JBZipFile myFile;
    protected static final byte[] LFH_SIG = ZipLong.getBytes(67324752L);
    protected static final byte[] CFH_SIG = ZipLong.getBytes(33639248L);
    protected static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    private final BufferExposingByteArrayOutputStream myBuffer = new BufferExposingByteArrayOutputStream();

    public JBZipOutputStream(JBZipFile file2, long currentCDOffset) throws IOException {
        this.myFile = file2;
        this.raf = this.myFile.archive;
        this.writtenOnDisk = currentCDOffset;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void finish() throws IOException {
        long cdOffset = this.getWritten();
        List<JBZipEntry> entries2 = this.myFile.getEntries();
        int entriesSize = entries2.size();
        for (int i = 0; i < entriesSize; ++i) {
            this.writeCentralFileHeader(entries2.get(i));
        }
        long cdLength = this.getWritten() - cdOffset;
        this.writeCentralDirectoryEnd(cdLength, cdOffset);
        this.flushBuffer();
        this.def.end();
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + level);
        }
        this.level = level;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    protected void writeLocalFileHeader(JBZipEntry ze) throws IOException {
        ze.setHeaderOffset(this.getWritten());
        this.writeOut(LFH_SIG);
        this.writeOutShort(10);
        this.writeOutShort(0);
        this.writeOutShort(ze.getMethod());
        this.writeOutLong(DosTime.javaToDosTime(ze.getTime()));
        this.writeOutLong(ze.getCrc());
        this.writeOutLong(ze.getCompressedSize());
        this.writeOutLong(ze.getSize());
        byte[] name = this.getBytes(ze.getName());
        this.writeOutShort(name.length);
        byte[] extra = ze.getLocalFileDataExtra();
        this.writeOutShort(extra.length);
        this.writeOut(name);
        this.writeOut(extra);
    }

    private void updateLocalFileHeader(JBZipEntry ze, long crc, long compressedSize) throws IOException {
        ze.setCrc(crc);
        ze.setCompressedSize(compressedSize);
        this.flushBuffer();
        long offset2 = ze.getHeaderOffset() + 14L;
        this.raf.seek(offset2);
        this.raf.write(ZipLong.getBytes(crc));
        this.raf.write(ZipLong.getBytes(compressedSize));
    }

    private void writeOutShort(int s) throws IOException {
        this.writeOut(ZipShort.getBytes(s));
    }

    private void writeOutLong(long s) throws IOException {
        this.writeOut(ZipLong.getBytes(s));
    }

    protected void writeCentralFileHeader(JBZipEntry ze) throws IOException {
        this.writeOut(CFH_SIG);
        this.writeOutShort(ze.getPlatform() << 8 | 0x14);
        this.writeOutShort(10);
        this.writeOutShort(0);
        this.writeOutShort(ze.getMethod());
        this.writeOutLong(DosTime.javaToDosTime(ze.getTime()));
        this.writeOutLong(ze.getCrc());
        this.writeOutLong(ze.getCompressedSize());
        this.writeOutLong(ze.getSize());
        byte[] name = this.getBytes(ze.getName());
        this.writeOutShort(name.length);
        byte[] extra = ze.getExtra();
        this.writeOutShort(extra.length);
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        byte[] commentB = this.getBytes(comm);
        this.writeOutShort(commentB.length);
        this.writeOutShort(0);
        this.writeOutShort(ze.getInternalAttributes());
        this.writeOutLong(ze.getExternalAttributes());
        this.writeOutLong(ze.getHeaderOffset());
        this.writeOut(name);
        this.writeOut(extra);
        this.writeOut(commentB);
    }

    protected void writeCentralDirectoryEnd(long cdLength, long cdOffset) throws IOException {
        this.writeOut(EOCD_SIG);
        this.writeOutShort(0);
        this.writeOutShort(0);
        int entiresCount = this.myFile.getEntries().size();
        this.writeOutShort(entiresCount);
        this.writeOutShort(entiresCount);
        this.writeOutLong(cdLength);
        this.writeOutLong(cdOffset);
        byte[] data2 = this.getBytes(this.comment);
        this.writeOutShort(data2.length);
        this.writeOut(data2);
    }

    protected byte[] getBytes(String name) throws ZipException {
        if (this.encoding == null) {
            return name.getBytes();
        }
        try {
            return name.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    private void writeOut(byte[] data2) throws IOException {
        this.writeOut(data2, 0, data2.length);
    }

    private void writeOut(byte[] data2, int offset2, int length) throws IOException {
        this.myBuffer.write(data2, offset2, length);
        if (this.myBuffer.size() > 8192) {
            this.flushBuffer();
        }
    }

    void ensureFlushed(long end) throws IOException {
        if (end > this.writtenOnDisk) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.raf.seek(this.writtenOnDisk);
        this.raf.write(this.myBuffer.getInternalBuffer(), 0, this.myBuffer.size());
        this.writtenOnDisk += (long)this.myBuffer.size();
        this.myBuffer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNextEntryBytes(JBZipEntry entry, byte[] bytes) throws IOException {
        byte[] outputBytes;
        int outputBytesLength;
        this.prepareNextEntry(entry, bytes.length);
        this.crc.reset();
        this.crc.update(bytes);
        entry.setCrc(this.crc.getValue());
        if (entry.getMethod() == 8) {
            this.def.setLevel(this.level);
            BufferExposingByteArrayOutputStream compressedBytesStream = new BufferExposingByteArrayOutputStream();
            DeflaterOutputStream stream2 = new DeflaterOutputStream((OutputStream)compressedBytesStream, this.def);
            try {
                stream2.write(bytes);
            }
            finally {
                stream2.close();
            }
            outputBytesLength = compressedBytesStream.size();
            outputBytes = compressedBytesStream.getInternalBuffer();
        } else {
            outputBytesLength = bytes.length;
            outputBytes = bytes;
        }
        entry.setCompressedSize(outputBytesLength);
        this.writeLocalFileHeader(entry);
        this.writeOut(outputBytes, 0, outputBytesLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putNextEntryContent(JBZipEntry entry, long size, InputStream content2) throws IOException {
        FilterOutputStream output;
        this.prepareNextEntry(entry, size);
        this.writeLocalFileHeader(entry);
        this.flushBuffer();
        RandomAccessFileOutputStream fileOutput = new RandomAccessFileOutputStream(this.raf);
        BufferedOutputStream bufferedFileOutput = new BufferedOutputStream(fileOutput);
        if (entry.getMethod() == 8) {
            this.def.setLevel(this.level);
            output = new DeflaterOutputStream((OutputStream)bufferedFileOutput, this.def);
        } else {
            output = bufferedFileOutput;
        }
        try {
            int count2;
            byte[] buffer = new byte[10240];
            this.crc.reset();
            while ((count2 = content2.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, count2);
                this.crc.update(buffer, 0, count2);
            }
        }
        finally {
            ((OutputStream)output).close();
        }
        this.writtenOnDisk += fileOutput.myWrittenBytes;
        this.updateLocalFileHeader(entry, this.crc.getValue(), fileOutput.myWrittenBytes);
    }

    private void prepareNextEntry(JBZipEntry entry, long size) {
        entry.setSize(size);
        if (entry.getMethod() == -1) {
            entry.setMethod(this.method);
        }
        if (entry.getTime() == -1L) {
            entry.setTime(System.currentTimeMillis());
        }
    }

    long getWritten() {
        return this.writtenOnDisk + (long)this.myBuffer.size();
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private final RandomAccessFile myFile;
        private long myWrittenBytes;

        public RandomAccessFileOutputStream(RandomAccessFile file2) {
            this.myFile = file2;
        }

        @Override
        public void write(int b) throws IOException {
            this.myFile.write(b);
            ++this.myWrittenBytes;
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                RandomAccessFileOutputStream.$$$reportNull$$$0(0);
            }
            this.myFile.write(b, off, len);
            this.myWrittenBytes += (long)len;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/zip/JBZipOutputStream$RandomAccessFileOutputStream", "write"));
        }
    }
}

