/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.JarMemoryLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JarLoader
extends Loader {
    private static final List<Pair<Resource.Attribute, Attributes.Name>> PACKAGE_FIELDS = Arrays.asList(Pair.pair(Resource.Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), Pair.pair(Resource.Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), Pair.pair(Resource.Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), Pair.pair(Resource.Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), Pair.pair(Resource.Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), Pair.pair(Resource.Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR));
    private final File myCanonicalFile;
    private final boolean myCanLockJar;
    private SoftReference<JarMemoryLoader> myMemoryLoader;
    private volatile SoftReference<ZipFile> myZipFileSoftReference;
    private final Map<Resource.Attribute, String> myAttributes;
    private static final Object ourLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarLoader(URL url, boolean canLockJar, int index2, boolean preloadJarContents) throws IOException {
        super(new URL("jar", "", -1, url + "!/"), index2);
        this.myCanonicalFile = new File(FileUtil.unquote(url.getFile())).getCanonicalFile();
        this.myCanLockJar = canLockJar;
        ZipFile zipFile2 = this.getZipFile();
        try {
            JarMemoryLoader loader;
            this.myAttributes = JarLoader.getAttributes(zipFile2);
            if (preloadJarContents && (loader = JarMemoryLoader.load(zipFile2, this.getBaseURL(), this.myAttributes)) != null) {
                this.myMemoryLoader = new SoftReference<JarMemoryLoader>(loader);
            }
        }
        finally {
            this.releaseZipFile(zipFile2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Map<Resource.Attribute, String> getAttributes(ZipFile zipFile2) {
        ZipEntry entry = zipFile2.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            return null;
        }
        EnumMap<Resource.Attribute, String> map2 = null;
        try {
            InputStream stream2 = zipFile2.getInputStream(entry);
            try {
                Attributes attributes = new Manifest(stream2).getMainAttributes();
                for (Pair<Resource.Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
                    String value = attributes.getValue((Attributes.Name)p.second);
                    if (value == null) continue;
                    if (map2 == null) {
                        map2 = new EnumMap<Resource.Attribute, String>(Resource.Attribute.class);
                    }
                    map2.put((Resource.Attribute)((Object)p.first), value);
                }
            }
            finally {
                stream2.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        ZipFile zipFile2 = this.getZipFile();
        ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData();
        Enumeration<? extends ZipEntry> entries2 = zipFile2.entries();
        while (entries2.hasMoreElements()) {
            ZipEntry entry = entries2.nextElement();
            String name = entry.getName();
            loaderData.addResourceEntry(name);
            loaderData.addNameEntry(name);
        }
        ClasspathCache.LoaderData loaderData2 = loaderData;
        ClasspathCache.LoaderData loaderData3 = loaderData2;
        if (loaderData3 == null) {
            JarLoader.$$$reportNull$$$0(0);
        }
        return loaderData3;
        finally {
            this.releaseZipFile(zipFile2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    Resource getResource(String name, boolean flag) {
        Resource resource;
        JarMemoryLoader loader;
        JarMemoryLoader jarMemoryLoader = loader = this.myMemoryLoader != null ? (JarMemoryLoader)this.myMemoryLoader.get() : null;
        if (loader != null && (resource = loader.getResource(name)) != null) {
            return resource;
        }
        try {
            ZipFile zipFile2 = this.getZipFile();
            try {
                ZipEntry entry = zipFile2.getEntry(name);
                if (entry == null) return null;
                MyResource myResource = new MyResource(this.getBaseURL(), entry);
                return myResource;
            }
            finally {
                this.releaseZipFile(zipFile2);
            }
        }
        catch (Exception e) {
            this.error("file: " + this.myCanonicalFile, e);
        }
        return null;
    }

    protected void error(String message, Throwable t) {
        Logger.getInstance(JarLoader.class).error(message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ZipFile getZipFile() throws IOException {
        if (!this.myCanLockJar) {
            ZipFile zipFile2 = new ZipFile(this.myCanonicalFile);
            if (zipFile2 != null) return zipFile2;
            JarLoader.$$$reportNull$$$0(4);
            return zipFile2;
        }
        ZipFile zipFile3 = SoftReference.dereference(this.myZipFileSoftReference);
        if (zipFile3 != null) {
            ZipFile zipFile4 = zipFile3;
            if (zipFile4 != null) return zipFile4;
            JarLoader.$$$reportNull$$$0(1);
            return zipFile4;
        }
        Object object = ourLock;
        // MONITORENTER : object
        zipFile3 = SoftReference.dereference(this.myZipFileSoftReference);
        if (zipFile3 != null) {
            ZipFile zipFile5 = zipFile3;
            // MONITOREXIT : object
            if (zipFile5 != null) return zipFile5;
            JarLoader.$$$reportNull$$$0(2);
            return zipFile5;
        }
        zipFile3 = new ZipFile(this.myCanonicalFile);
        this.myZipFileSoftReference = new SoftReference<ZipFile>(zipFile3);
        ZipFile zipFile6 = zipFile3;
        // MONITOREXIT : object
        if (zipFile6 != null) return zipFile6;
        JarLoader.$$$reportNull$$$0(3);
        return zipFile6;
    }

    private void releaseZipFile(ZipFile zipFile2) throws IOException {
        if (!this.myCanLockJar) {
            zipFile2.close();
        }
    }

    public String toString() {
        return "JarLoader [" + this.myCanonicalFile + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/lang/JarLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MyResource
    extends Resource {
        private final URL myUrl;
        private final ZipEntry myEntry;

        public MyResource(URL url, ZipEntry entry) throws IOException {
            this.myUrl = new URL(url, entry.getName());
            this.myEntry = entry;
        }

        @Override
        public URL getURL() {
            return this.myUrl;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBytes() throws IOException {
            ZipFile file2 = JarLoader.this.getZipFile();
            InputStream stream2 = null;
            try {
                stream2 = file2.getInputStream(this.myEntry);
                byte[] byArray = FileUtil.loadBytes(stream2, (int)this.myEntry.getSize());
                return byArray;
            }
            finally {
                if (stream2 != null) {
                    stream2.close();
                }
                JarLoader.this.releaseZipFile(file2);
            }
        }

        @Override
        public String getValue(Resource.Attribute key) {
            return JarLoader.this.myAttributes != null ? (String)JarLoader.this.myAttributes.get((Object)key) : null;
        }
    }
}

