/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.VerifyingVisitor;

public class DefaultPicoContainer
implements AreaPicoContainer {
    private final PicoContainer parent;
    private final Set<PicoContainer> children = new THashSet<PicoContainer>();
    private final Map<Object, ComponentAdapter> componentKeyToAdapterCache = ContainerUtil.newConcurrentMap();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();
    private final Map<String, ComponentAdapter> classNameToAdapter = ContainerUtil.newConcurrentMap();
    private final AtomicReference<FList<ComponentAdapter>> nonAssignableComponentAdapters = new AtomicReference(FList.emptyList());

    public DefaultPicoContainer(@Nullable PicoContainer parent2) {
        this.parent = parent2 == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance(parent2);
    }

    public DefaultPicoContainer() {
        this(null);
    }

    @Override
    public Collection<ComponentAdapter> getComponentAdapters() {
        return this.componentAdapters.getImmutableSet();
    }

    private void appendNonAssignableAdaptersOfType(@NotNull Class componentType, @NotNull List<ComponentAdapter> result2) {
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            DefaultPicoContainer.$$$reportNull$$$0(1);
        }
        ArrayList<ComponentAdapter> comp2 = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.nonAssignableComponentAdapters.get()) {
            if (!ReflectionUtil.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            comp2.add(componentAdapter);
        }
        for (int i = comp2.size() - 1; i >= 0; --i) {
            result2.add((ComponentAdapter)comp2.get(i));
        }
    }

    @Override
    @Nullable
    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    private ComponentAdapter getFromCache(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.get(componentKey);
        if (adapter != null) {
            return adapter;
        }
        if (componentKey instanceof Class) {
            return this.componentKeyToAdapterCache.get(((Class)componentKey).getName());
        }
        return null;
    }

    @Override
    @Nullable
    public ComponentAdapter getComponentAdapterOfType(@NotNull Class componentType) {
        ComponentAdapter adapterByKey;
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(2);
        }
        if ((adapterByKey = this.getComponentAdapter(componentType)) != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @Override
    public List<ComponentAdapter> getComponentAdaptersOfType(Class componentType) {
        if (componentType == null || componentType == String.class) {
            return Collections.emptyList();
        }
        SmartList<ComponentAdapter> result2 = new SmartList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.classNameToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result2.add(cacheHit);
        }
        this.appendNonAssignableAdaptersOfType(componentType, result2);
        return result2;
    }

    @Override
    public ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        Object componentKey;
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(3);
        }
        if (this.componentKeyToAdapterCache.containsKey(componentKey = componentAdapter.getComponentKey())) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        if (componentAdapter instanceof AssignableToComponentAdapter) {
            String classKey = ((AssignableToComponentAdapter)componentAdapter).getAssignableToClassName();
            this.classNameToAdapter.put(classKey, componentAdapter);
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.prepend(componentAdapter))) {
            }
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    @Override
    public ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(4);
        }
        ComponentAdapter adapter = this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        if (adapter instanceof AssignableToComponentAdapter) {
            this.classNameToAdapter.remove(((AssignableToComponentAdapter)adapter).getAssignableToClassName());
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.without(adapter))) {
            }
        }
        return adapter;
    }

    public List getComponentInstances() {
        return this.getComponentInstancesOfType(Object.class);
    }

    public List<Object> getComponentInstancesOfType(@Nullable Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (ComponentAdapter componentAdapter : this.getComponentAdapters()) {
            if (!ReflectionUtil.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            ContainerUtil.addIfNotNull(result2, this.getInstance(componentAdapter));
        }
        return result2;
    }

    @Override
    @Nullable
    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter != null) {
            return this.getLocalInstance(adapter);
        }
        if (this.parent != null && (adapter = this.parent.getComponentAdapter(componentKey)) != null) {
            return this.parent.getComponentInstance(adapter.getComponentKey());
        }
        return null;
    }

    @Nullable
    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    @Nullable
    private Object getInstance(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(5);
        }
        if (this.getComponentAdapters().contains(componentAdapter)) {
            return this.getLocalInstance(componentAdapter);
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private Object getLocalInstance(@NotNull ComponentAdapter componentAdapter) {
        Object instance;
        PicoException firstLevelException;
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(6);
        }
        try {
            return componentAdapter.getComponentInstance(this);
        }
        catch (PicoInitializationException e) {
            firstLevelException = e;
        }
        catch (PicoIntrospectionException e) {
            firstLevelException = e;
        }
        if (this.parent != null && (instance = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
            return instance;
        }
        throw firstLevelException;
    }

    @Nullable
    public ComponentAdapter unregisterComponentByInstance(@NotNull Object componentInstance) {
        if (componentInstance == null) {
            DefaultPicoContainer.$$$reportNull$$$0(7);
        }
        for (ComponentAdapter adapter : this.getComponentAdapters()) {
            Object o = this.getInstance(adapter);
            if (o == null || !o.equals(componentInstance)) continue;
            return this.unregisterComponent(adapter.getComponentKey());
        }
        return null;
    }

    public void verify() {
        new VerifyingVisitor().traverse((Object)this);
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer(this);
        this.addChildContainer(pc);
        DefaultPicoContainer defaultPicoContainer = pc;
        if (defaultPicoContainer == null) {
            DefaultPicoContainer.$$$reportNull$$$0(8);
        }
        return defaultPicoContainer;
    }

    public boolean addChildContainer(@NotNull PicoContainer child) {
        if (child == null) {
            DefaultPicoContainer.$$$reportNull$$$0(9);
        }
        return this.children.add(child);
    }

    public boolean removeChildContainer(@NotNull PicoContainer child) {
        if (child == null) {
            DefaultPicoContainer.$$$reportNull$$$0(10);
        }
        return this.children.remove(child);
    }

    public void accept(PicoVisitor visitor2) {
        visitor2.visitContainer((PicoContainer)this);
        for (ComponentAdapter adapter : this.getComponentAdapters()) {
            adapter.accept(visitor2);
        }
        for (PicoContainer child : new SmartList<PicoContainer>((Collection<PicoContainer>)this.children)) {
            child.accept(visitor2);
        }
    }

    @Override
    public ComponentAdapter registerComponentInstance(@NotNull Object component) {
        if (component == null) {
            DefaultPicoContainer.$$$reportNull$$$0(11);
        }
        return this.registerComponentInstance(component.getClass(), component);
    }

    @Override
    public ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(12);
        }
        if (componentInstance == null) {
            DefaultPicoContainer.$$$reportNull$$$0(13);
        }
        return this.registerComponent(new InstanceComponentAdapter(componentKey, componentInstance));
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Class componentImplementation) {
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(14);
        }
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    @Override
    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(15);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(16);
        }
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters2) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(17);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(18);
        }
        CachingConstructorInjectionComponentAdapter componentAdapter = new CachingConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters2, true);
        return this.registerComponent(componentAdapter);
    }

    @Override
    public PicoContainer getParent() {
        return this.parent;
    }

    public String toString() {
        return "DefaultPicoContainer" + (this.getParent() == null ? " (root)" : " (parent=" + this.getParent() + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentAdapter";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentInstance";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makeChildContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendNonAssignableAdaptersOfType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapterOfType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalInstance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponentByInstance";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addChildContainer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeChildContainer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element) {
            if (element == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(0);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<T> getImmutableSet() {
            Set<T> res2 = this.immutableSet;
            if (res2 == null) {
                Object object = this.lock;
                synchronized (object) {
                    res2 = this.immutableSet;
                    if (res2 == null) {
                        this.immutableSet = res2 = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            Set<T> set = res2;
            if (set == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImmutableSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

