/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SemVer
implements Comparable<SemVer> {
    public static final SemVer UNKNOWN = new SemVer("?", 0, 0, 0);
    private final String myRawVersion;
    private final int myMajor;
    private final int myMinor;
    private final int myPatch;

    public SemVer(@NotNull String rawVersion, int major, int minor, int patch) {
        if (rawVersion == null) {
            SemVer.$$$reportNull$$$0(0);
        }
        this.myRawVersion = rawVersion;
        this.myMajor = major;
        this.myMinor = minor;
        this.myPatch = patch;
    }

    @NotNull
    public String getRawVersion() {
        String string = this.myRawVersion;
        if (string == null) {
            SemVer.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getPatch() {
        return this.myPatch;
    }

    @NotNull
    public String getParsedVersion() {
        String string = this.myMajor + "." + this.myMinor + "." + this.myPatch;
        if (string == null) {
            SemVer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public int compareTo(SemVer other) {
        int diff = this.myMajor - other.myMajor;
        if (diff != 0) {
            return diff;
        }
        diff = this.myMinor - other.myMinor;
        if (diff != 0) {
            return diff;
        }
        return this.myPatch - other.myPatch;
    }

    public boolean isGreaterOrEqualThan(int major, int minor, int patch) {
        if (this.myMajor != major) {
            return this.myMajor > major;
        }
        if (this.myMinor != minor) {
            return this.myMinor > minor;
        }
        return this.myPatch >= patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        return this.myMajor == semVer.myMajor && this.myMinor == semVer.myMinor && this.myPatch == semVer.myPatch;
    }

    public int hashCode() {
        int result2 = this.myMajor;
        result2 = 31 * result2 + this.myMinor;
        result2 = 31 * result2 + this.myPatch;
        return result2;
    }

    public String toString() {
        return this.myRawVersion;
    }

    @Nullable
    public static SemVer parseFromText(@Nullable String text2) {
        int minorEndIdx;
        int majorEndIdx;
        if (text2 != null && (majorEndIdx = text2.indexOf(46)) >= 0 && (minorEndIdx = text2.indexOf(46, majorEndIdx + 1)) >= 0) {
            int patchEndIdx = text2.indexOf(45, minorEndIdx + 1);
            if (patchEndIdx < 0) {
                patchEndIdx = text2.length();
            }
            int major = StringUtil.parseInt(text2.substring(0, majorEndIdx), -1);
            int minor = StringUtil.parseInt(text2.substring(majorEndIdx + 1, minorEndIdx), -1);
            int patch = StringUtil.parseInt(text2.substring(minorEndIdx + 1, patchEndIdx), -1);
            if (major >= 0 && minor >= 0 && patch >= 0) {
                return new SemVer(text2, major, minor, patch);
            }
        }
        return null;
    }

    public static SemVer parseFromTextNonNullize(@Nullable String text2) {
        if (text2 == null) {
            return UNKNOWN;
        }
        SemVer ver = SemVer.parseFromText(text2);
        return ver == null ? UNKNOWN : ver;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/SemVer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/SemVer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParsedVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

