/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.Gray;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;

public class ColorIcon
extends EmptyIcon {
    private final Color myColor;
    private final boolean myBorder;
    private final int myColorSize;

    public ColorIcon(int size, int colorSize, @NotNull Color color, boolean border) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(0);
        }
        super(size, size);
        this.myColor = color;
        this.myColorSize = colorSize;
        this.myBorder = border;
    }

    public ColorIcon(int size, @NotNull Color color, boolean border) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(1);
        }
        this(size, size, color, border);
    }

    public ColorIcon(int size, @NotNull Color color) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(2);
        }
        this(size, color, false);
    }

    protected ColorIcon(ColorIcon icon) {
        super(icon);
        this.myColor = icon.myColor;
        this.myBorder = icon.myBorder;
        this.myColorSize = icon.myColorSize;
    }

    @Override
    @NotNull
    protected ColorIcon copy() {
        ColorIcon colorIcon = new ColorIcon(this);
        if (colorIcon == null) {
            ColorIcon.$$$reportNull$$$0(3);
        }
        return colorIcon;
    }

    public Color getIconColor() {
        return this.myColor;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        g.setColor(this.getIconColor());
        int size = this.getColorSize();
        int x = i + (iconWidth - size) / 2;
        int y = j + (iconHeight - size) / 2;
        g.fillRect(x, y, size, size);
        if (this.myBorder) {
            g.setColor(Gray.x00.withAlpha(40));
            g.drawRect(x, y, size, size);
        }
    }

    private int getColorSize() {
        return (int)Math.ceil(this.scaleVal(this.myColorSize));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColorIcon icon = (ColorIcon)o;
        if (this.myBorder != icon.myBorder) {
            return false;
        }
        if (this.myColorSize != icon.myColorSize) {
            return false;
        }
        return !(this.myColor != null ? !this.myColor.equals(icon.myColor) : icon.myColor != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.myColor != null ? this.myColor.hashCode() : 0);
        result2 = 31 * result2 + (this.myBorder ? 1 : 0);
        result2 = 31 * result2 + this.myColorSize;
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ColorIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ColorIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

