/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MouseInputListener;
import org.jetbrains.annotations.NotNull;

public class MouseEventAdapter<T>
extends MouseAdapter
implements MouseInputListener {
    private final T myAdapter;

    public MouseEventAdapter(T adapter) {
        this.myAdapter = adapter;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseEntered(this.convert(event));
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mousePressed(this.convert(event));
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseClicked(this.convert(event));
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseReleased(this.convert(event));
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseExited(this.convert(event));
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        MouseMotionListener listener = this.getMouseMotionListener(this.myAdapter);
        if (listener != null) {
            listener.mouseMoved(this.convert(event));
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        MouseMotionListener listener = this.getMouseMotionListener(this.myAdapter);
        if (listener != null) {
            listener.mouseDragged(this.convert(event));
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        MouseWheelListener listener = this.getMouseWheelListener(this.myAdapter);
        if (listener != null) {
            listener.mouseWheelMoved(this.convert(event));
        }
    }

    protected MouseListener getMouseListener(T adapter) {
        return adapter instanceof MouseListener ? (MouseListener)adapter : null;
    }

    protected MouseMotionListener getMouseMotionListener(T adapter) {
        return adapter instanceof MouseMotionListener ? (MouseMotionListener)adapter : null;
    }

    protected MouseWheelListener getMouseWheelListener(T adapter) {
        return adapter instanceof MouseWheelListener ? (MouseWheelListener)adapter : null;
    }

    @NotNull
    protected MouseEvent convert(@NotNull MouseEvent event) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(0);
        }
        MouseEvent mouseEvent = event;
        if (mouseEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(1);
        }
        return mouseEvent;
    }

    @NotNull
    protected MouseWheelEvent convert(@NotNull MouseWheelEvent event) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(2);
        }
        MouseWheelEvent mouseWheelEvent = event;
        if (mouseWheelEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(3);
        }
        return mouseWheelEvent;
    }

    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(4);
        }
        Point point = event.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(point, source);
        MouseEvent mouseEvent = MouseEventAdapter.convert(event, source, point.x, point.y);
        if (mouseEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(5);
        }
        return mouseEvent;
    }

    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source, int x, int y) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(6);
        }
        MouseEvent mouseEvent = MouseEventAdapter.convert(event, source, event.getID(), event.getWhen(), event.getModifiers() | event.getModifiersEx(), x, y);
        if (mouseEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(7);
        }
        return mouseEvent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source, int id, long when, int modifiers2, int x, int n) {
        void y;
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(8);
        }
        if (event instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = MouseEventAdapter.convert((MouseWheelEvent)event, source, id, when, modifiers2, x, (int)y);
            if (mouseWheelEvent == null) {
                MouseEventAdapter.$$$reportNull$$$0(9);
            }
            return mouseWheelEvent;
        }
        if (event instanceof MenuDragMouseEvent) {
            MenuDragMouseEvent menuDragMouseEvent = MouseEventAdapter.convert((MenuDragMouseEvent)event, source, id, when, modifiers2, x, (int)y);
            if (menuDragMouseEvent == null) {
                MouseEventAdapter.$$$reportNull$$$0(10);
            }
            return menuDragMouseEvent;
        }
        MouseEvent mouseEvent = new MouseEvent(source, id, when, modifiers2, x, (int)y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
        if (mouseEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(11);
        }
        return mouseEvent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static MouseWheelEvent convert(@NotNull MouseWheelEvent event, Component source, int id, long when, int modifiers2, int x, int n) {
        void y;
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(12);
        }
        MouseWheelEvent mouseWheelEvent = new MouseWheelEvent(source, id, when, modifiers2, x, (int)y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getScrollType(), event.getScrollAmount(), event.getWheelRotation());
        if (mouseWheelEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(13);
        }
        return mouseWheelEvent;
    }

    @NotNull
    public static MenuDragMouseEvent convert(MenuDragMouseEvent event, Component source, int id, long when, int modifiers2, int x, int y) {
        MenuDragMouseEvent menuDragMouseEvent = new MenuDragMouseEvent(source, id, when, modifiers2, x, y, event.getClickCount(), event.isPopupTrigger(), event.getPath(), event.getMenuSelectionManager());
        if (menuDragMouseEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(14);
        }
        return menuDragMouseEvent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/MouseEventAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/MouseEventAdapter";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

