/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;

public class SplitByLetterPolicy
extends FilePathSplittingPolicy {
    protected SplitByLetterPolicy() {
    }

    @Override
    public String getPresentableName(File file2, int count2) {
        String filePath = file2.getPath();
        if (count2 >= filePath.length()) {
            return filePath;
        }
        int nameLength = file2.getName().length();
        if (count2 <= nameLength) {
            return filePath.substring(filePath.length() - count2);
        }
        int dotsCount = Math.min(3, count2 - nameLength);
        int shownCount = count2 - dotsCount;
        int leftCount = (shownCount - nameLength) / 2 + (shownCount - nameLength) % 2;
        int rightCount = shownCount - leftCount;
        return filePath.substring(0, leftCount) + SplitByLetterPolicy.dots(dotsCount) + filePath.substring(filePath.length() - rightCount);
    }

    private static String dots(int count2) {
        switch (count2) {
            case 1: {
                return ".";
            }
            case 2: {
                return "..";
            }
        }
        return "...";
    }
}

