/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessibleContextUtil {
    static final String PUNCTUATION_CHARACTER = ".";
    static final String PUNCTUATION_SEPARATOR = "  ";

    public static void setName(@NotNull JComponent component, @NotNull String name) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AccessibleContextUtil.$$$reportNull$$$0(1);
        }
        component.getAccessibleContext().setAccessibleName(name);
    }

    public static void setName(@NotNull JComponent component, @NotNull JComponent source) {
        String name;
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(2);
        }
        if (source == null) {
            AccessibleContextUtil.$$$reportNull$$$0(3);
        }
        if ((name = source.getAccessibleContext().getAccessibleName()) != null) {
            component.getAccessibleContext().setAccessibleName(name);
        }
    }

    public static void setCombinedName(@NotNull JComponent component, @NotNull JComponent j1, @NotNull String separator, @NotNull JComponent j2) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(4);
        }
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(5);
        }
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(6);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(7);
        }
        component.getAccessibleContext().setAccessibleName(AccessibleContextUtil.combineAccessibleStrings(j1.getAccessibleContext().getAccessibleName(), separator, j2.getAccessibleContext().getAccessibleName()));
    }

    public static void setCombinedName(@NotNull JComponent component, @NotNull JComponent j1, @NotNull String separator1, @NotNull JComponent j2, @NotNull String separator2, @NotNull JComponent j3) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(8);
        }
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(9);
        }
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(10);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(11);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(12);
        }
        if (j3 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(13);
        }
        component.getAccessibleContext().setAccessibleName(AccessibleContextUtil.combineAccessibleStrings(j1.getAccessibleContext().getAccessibleName(), separator1, j2.getAccessibleContext().getAccessibleName(), separator2, j3.getAccessibleContext().getAccessibleName()));
    }

    public static void setDescription(@NotNull JComponent component, @NotNull JComponent source) {
        String description2;
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(14);
        }
        if (source == null) {
            AccessibleContextUtil.$$$reportNull$$$0(15);
        }
        if ((description2 = source.getAccessibleContext().getAccessibleDescription()) != null) {
            component.getAccessibleContext().setAccessibleDescription(description2);
        }
    }

    public static void setCombinedDescription(@NotNull JComponent component, @NotNull JComponent j1, @NotNull String separator, @NotNull JComponent j2) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(16);
        }
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(17);
        }
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(18);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(19);
        }
        component.getAccessibleContext().setAccessibleDescription(AccessibleContextUtil.combineAccessibleStrings(j1.getAccessibleContext().getAccessibleDescription(), separator, j2.getAccessibleContext().getAccessibleDescription()));
    }

    public static void setCombinedDescription(@NotNull JComponent component, @NotNull JComponent j1, @NotNull String separator1, @NotNull JComponent j2, @NotNull String separator2, @NotNull JComponent j3) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(20);
        }
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(21);
        }
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(22);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(23);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(24);
        }
        if (j3 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(25);
        }
        component.getAccessibleContext().setAccessibleDescription(AccessibleContextUtil.combineAccessibleStrings(j1.getAccessibleContext().getAccessibleDescription(), separator1, j2.getAccessibleContext().getAccessibleDescription(), separator2, j3.getAccessibleContext().getAccessibleDescription()));
    }

    public static void setParent(@NotNull JComponent component, @Nullable Component newParent) {
        if (component == null) {
            AccessibleContextUtil.$$$reportNull$$$0(26);
        }
        if (newParent instanceof Accessible) {
            component.getAccessibleContext().setAccessibleParent((Accessible)((Object)newParent));
            return;
        }
        component.getAccessibleContext().setAccessibleParent(null);
    }

    @Nullable
    public static String combineAccessibleStrings(@Nullable String s1, @NotNull String separator, @Nullable String s2) {
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(27);
        }
        if (StringUtil.isEmpty(s1)) {
            return s2;
        }
        if (StringUtil.isEmpty(s2)) {
            return s1;
        }
        return String.format("%s%s%s", s1, separator, s2);
    }

    @Nullable
    public static String combineAccessibleStrings(@Nullable String s1, @NotNull String separator1, @Nullable String s2, @NotNull String separator2, @Nullable String s3) {
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(28);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(29);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.combineAccessibleStrings(s1, separator1, s2), separator2, s3);
    }

    @NotNull
    public static String replaceLineSeparatorsWithPunctuation(@Nullable String text2) {
        if (StringUtil.isEmpty(text2)) {
            if ("" == null) {
                AccessibleContextUtil.$$$reportNull$$$0(30);
            }
            return "";
        }
        String[] lines = StringUtil.splitByLines(text2);
        StringBuilder result2 = new StringBuilder();
        boolean first2 = true;
        for (String line : lines) {
            if (StringUtil.isEmpty(line = line.trim())) continue;
            if (first2) {
                first2 = false;
            } else {
                result2.append(PUNCTUATION_SEPARATOR);
            }
            result2.append(line);
            if (line.endsWith(PUNCTUATION_CHARACTER)) continue;
            result2.append(PUNCTUATION_CHARACTER);
        }
        String string = result2.toString();
        if (string == null) {
            AccessibleContextUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 9: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "j1";
                break;
            }
            case 6: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 7: 
            case 11: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "j2";
                break;
            }
            case 10: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator1";
                break;
            }
            case 12: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator2";
                break;
            }
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "j3";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/accessibility/AccessibleContextUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/accessibility/AccessibleContextUtil";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceLineSeparatorsWithPunctuation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCombinedName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setCombinedDescription";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "combineAccessibleStrings";
                break;
            }
            case 30: 
            case 31: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

