/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import gnu.trove.THashMap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding {
    private Map<Class<?>, Binding> itemBindings;
    protected final Class<?> itemType;
    @Nullable
    protected final AbstractCollection annotation;
    private Serializer serializer;

    public AbstractCollectionBinding(@NotNull Class elementType, @Nullable MutableAccessor accessor) {
        if (elementType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(0);
        }
        super(accessor);
        this.itemType = elementType;
        this.annotation = accessor == null ? null : accessor.getAnnotation(AbstractCollection.class);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        if (originalType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(1);
        }
        if (serializer2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(2);
        }
        this.serializer = serializer2;
        if (this.annotation == null || this.annotation.surroundWithTag()) {
            return;
        }
        if (StringUtil.isEmpty(this.annotation.elementTag()) || this.annotation.elementTag().equals("option") && serializer2.getBinding(this.itemType) == null) {
            throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
        }
    }

    @NotNull
    private synchronized Map<Class<?>, Binding> getElementBindings() {
        if (this.itemBindings == null) {
            Binding binding = this.serializer.getBinding(this.itemType);
            if (this.annotation == null || this.annotation.elementTypes().length == 0) {
                this.itemBindings = binding == null ? Collections.emptyMap() : Collections.singletonMap(this.itemType, binding);
            } else {
                this.itemBindings = new THashMap();
                if (binding != null) {
                    this.itemBindings.put(this.itemType, binding);
                }
                for (Class aClass2 : this.annotation.elementTypes()) {
                    Binding b = this.serializer.getBinding(aClass2);
                    if (b == null) continue;
                    this.itemBindings.put(aClass2, b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyMap();
                }
            }
        }
        Map<Class<?>, Binding> map2 = this.itemBindings;
        if (map2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element) {
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(4);
        }
        for (Binding binding : this.getElementBindings().values()) {
            if (!binding.isBoundTo(element)) continue;
            return binding;
        }
        return null;
    }

    @NotNull
    abstract Object processResult(@NotNull Collection var1, @Nullable Object var2);

    @NotNull
    abstract Collection<Object> getIterable(@NotNull Object var1);

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter2) {
        if (o == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(5);
        }
        Collection<Object> collection = this.getIterable(o);
        String tagName = this.getTagName(o);
        if (tagName == null) {
            SmartList result2 = new SmartList();
            if (!ContainerUtil.isEmpty(collection)) {
                for (Object item : collection) {
                    ContainerUtil.addAllNotNull(result2, this.serializeItem(item, result2, filter2));
                }
            }
            return result2;
        }
        Element result3 = new Element(tagName);
        if (!ContainerUtil.isEmpty(collection)) {
            for (Object item : collection) {
                Content child = (Content)this.serializeItem(item, result3, filter2);
                if (child == null) continue;
                result3.addContent(child);
            }
        }
        return result3;
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context, @NotNull List<Element> elements) {
        Collection<Object> result2;
        if (elements == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(6);
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result2 = (SmartList)context;
                result2.clear();
            } else {
                result2 = new SmartList();
            }
            for (Element node : elements) {
                result2.add(this.deserializeItem(node, context));
            }
            if (result2 == context) {
                return result2;
            }
        } else {
            assert (elements.size() == 1);
            result2 = this.deserializeSingle(context, elements.get(0));
        }
        return this.processResult(result2, context);
    }

    @Nullable
    private Object serializeItem(@Nullable Object value, Object context, @Nullable SerializationFilter filter2) {
        if (value == null) {
            LOG.warn("Collection " + this.myAccessor + " contains 'null' object");
            return null;
        }
        Binding binding = this.serializer.getBinding(value.getClass());
        if (binding == null) {
            Element serializedItem = new Element(this.annotation == null ? "option" : this.annotation.elementTag());
            String attributeName = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
            String serialized = XmlSerializerImpl.convertToString(value);
            if (attributeName.isEmpty()) {
                if (!serialized.isEmpty()) {
                    serializedItem.addContent(new Text(serialized));
                }
            } else {
                serializedItem.setAttribute(attributeName, XmlSerializerImpl.removeControlChars(serialized));
            }
            return serializedItem;
        }
        return binding.serialize(value, context, filter2);
    }

    private Object deserializeItem(@NotNull Element node, @Nullable Object context) {
        Binding binding;
        if (node == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(7);
        }
        if ((binding = this.getElementBinding(node)) == null) {
            String attributeName = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
            String value = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value, this.itemType);
        }
        return binding.deserializeUnsafe(context, node);
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        SmartList<Object> result2;
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(8);
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result2 = (Collection)context;
                result2.clear();
            } else {
                result2 = new SmartList<Object>();
            }
            result2.add(this.deserializeItem(element, context));
            if (result2 == context) {
                SmartList<Object> smartList = result2;
                if (smartList == null) {
                    AbstractCollectionBinding.$$$reportNull$$$0(9);
                }
                return smartList;
            }
        } else {
            result2 = this.deserializeSingle(context, element);
        }
        Object object = this.processResult(result2, context);
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(10);
        }
        return object;
    }

    @NotNull
    private Collection deserializeSingle(Object context, @NotNull Element node) {
        if (node == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(11);
        }
        Collection result2 = this.createCollection(node.getName());
        for (Element child : node.getChildren()) {
            result2.add(this.deserializeItem(child, context));
        }
        Collection collection = result2;
        if (collection == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(12);
        }
        return collection;
    }

    protected Collection createCollection(@NotNull String tagName) {
        if (tagName == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(13);
        }
        return new SmartList();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        String tagName;
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(14);
        }
        if ((tagName = this.getTagName(element)) == null) {
            if (element.getName().equals(this.annotation == null ? "option" : this.annotation.elementTag())) {
                return true;
            }
            if (this.getElementBinding(element) != null) {
                return true;
            }
        }
        return element.getName().equals(tagName);
    }

    @Nullable
    private String getTagName(@Nullable Object target) {
        return this.annotation == null || this.annotation.surroundWithTag() ? this.getCollectionTagName(target) : null;
    }

    protected abstract String getCollectionTagName(@Nullable Object var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 4: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementBindings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeSingle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementBinding";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserializeItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserializeSingle";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCollection";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

