/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XmlTagNamesIndex;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlNamespaceHelper
extends XmlNamespaceHelper {
    private static final Logger LOG = Logger.getInstance(DefaultXmlNamespaceHelper.class);

    @Override
    protected boolean isAvailable(PsiFile file2) {
        return true;
    }

    @Override
    public void insertNamespaceDeclaration(@NotNull XmlFile file2, @Nullable Editor editor, @NotNull Set<String> possibleNamespaces, @Nullable String nsPrefix, @Nullable XmlNamespaceHelper.Runner<String, IncorrectOperationException> runAfter) throws IncorrectOperationException {
        XmlAttribute xmlAttribute;
        if (file2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(0);
        }
        if (possibleNamespaces == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(1);
        }
        String namespace = possibleNamespaces.iterator().next();
        Project project = file2.getProject();
        XmlTag rootTag = file2.getRootTag();
        assert (rootTag != null);
        XmlAttribute anchor2 = DefaultXmlNamespaceHelper.getAnchor(rootTag);
        List<XmlSchemaProvider> providers = XmlSchemaProvider.getAvailableProviders(file2);
        String prefix = DefaultXmlNamespaceHelper.getPrefix(file2, nsPrefix, namespace, providers);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance(project);
        String location2 = DefaultXmlNamespaceHelper.getLocation(file2, namespace, providers);
        String xsiPrefix = null;
        if (location2 != null && (xsiPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = "xsi";
            rootTag.add(elementFactory.createXmlAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        }
        String qname = "xmlns" + (prefix.length() > 0 ? ":" + prefix : "");
        XmlAttribute attribute = elementFactory.createXmlAttribute(qname, namespace);
        if (anchor2 == null) {
            rootTag.add(attribute);
        } else {
            rootTag.addAfter(attribute, anchor2);
        }
        if (location2 != null) {
            XmlAttribute locationAttribute = rootTag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
            String pair = namespace + " " + location2;
            if (locationAttribute == null) {
                locationAttribute = elementFactory.createXmlAttribute(xsiPrefix + ":" + "schemaLocation", pair);
                rootTag.add(locationAttribute);
            } else {
                String value = locationAttribute.getValue();
                if (!StringUtil.notNullize(value).contains(namespace)) {
                    if (value == null || StringUtil.isEmptyOrSpaces(value)) {
                        locationAttribute.setValue(pair);
                    } else {
                        locationAttribute.setValue(value.trim() + " " + pair);
                    }
                }
            }
        }
        XmlUtil.reformatTagStart(rootTag);
        if (editor != null && namespace.length() == 0 && (xmlAttribute = rootTag.getAttribute(qname)) != null) {
            XmlAttributeValue value = xmlAttribute.getValueElement();
            assert (value != null);
            int startOffset = value.getTextOffset();
            editor.getCaretModel().moveToOffset(startOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        if (runAfter != null) {
            runAfter.run(prefix);
        }
    }

    private static String getPrefix(XmlFile file2, String nsPrefix, String namespace, List<XmlSchemaProvider> providers) {
        String prefix = nsPrefix;
        if (prefix == null) {
            XmlSchemaProvider provider;
            Iterator<XmlSchemaProvider> iterator2 = providers.iterator();
            while (iterator2.hasNext() && (prefix = (provider = iterator2.next()).getDefaultPrefix(namespace, file2)) == null) {
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    private static XmlAttribute getAnchor(XmlTag rootTag) {
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute anchor2 = null;
        for (XmlAttribute attribute : attributes) {
            XmlAttributeDescriptor descriptor2 = attribute.getDescriptor();
            if (!attribute.isNamespaceDeclaration() && (descriptor2 == null || !descriptor2.isRequired())) break;
            anchor2 = attribute;
        }
        return anchor2;
    }

    private static String getLocation(XmlFile file2, String namespace, List<XmlSchemaProvider> providers) {
        String location2 = null;
        if (namespace.length() > 0) {
            for (XmlSchemaProvider provider : providers) {
                Set<String> locations = provider.getLocations(namespace, file2);
                if (locations == null || locations.isEmpty()) continue;
                location2 = locations.iterator().next();
            }
        }
        return location2;
    }

    @Override
    @NotNull
    public Set<String> guessUnboundNamespaces(@NotNull PsiElement element, @NotNull XmlFile file2) {
        if (element == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(3);
        }
        if (!(element instanceof XmlTag)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                DefaultXmlNamespaceHelper.$$$reportNull$$$0(4);
            }
            return set;
        }
        XmlTag tag = (XmlTag)element;
        String name = tag.getLocalName();
        Set<String> byTagName = this.getNamespacesByTagName(name, file2);
        if (!byTagName.isEmpty()) {
            HashSet<String> filtered = new HashSet<String>(byTagName);
            filtered.removeAll(Arrays.asList(tag.knownNamespaces()));
            HashSet<String> hashSet = filtered;
            if (hashSet == null) {
                DefaultXmlNamespaceHelper.$$$reportNull$$$0(5);
            }
            return hashSet;
        }
        Set<String> set = DefaultXmlNamespaceHelper.guessNamespace(file2, name);
        set.removeAll(Arrays.asList(tag.knownNamespaces()));
        XmlTag parentTag = tag.getParentTag();
        Iterator<String> i = set.iterator();
        block0: while (i.hasNext()) {
            String s = i.next();
            Collection<XmlFile> namespaces = XmlUtil.findNSFilesByURI(s, element.getProject(), ModuleUtilCore.findModuleForPsiElement(file2));
            for (XmlFile namespace : namespaces) {
                XmlElementDescriptor[] descriptors;
                XmlDocument document = namespace.getDocument();
                assert (document != null);
                XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
                assert (nsDescriptor != null);
                if (parentTag != null) continue block0;
                for (XmlElementDescriptor descriptor2 : descriptors = nsDescriptor.getRootElementsDescriptors(document)) {
                    if (descriptor2 == null) {
                        LOG.error(nsDescriptor + " returned null element for getRootElementsDescriptors() array");
                        continue;
                    }
                    if (descriptor2.getName().equals(name)) continue block0;
                }
            }
            i.remove();
        }
        Set<String> set2 = set;
        if (set2 == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(6);
        }
        return set2;
    }

    private static Set<String> guessNamespace(PsiFile file2, String tagName) {
        Project project = file2.getProject();
        Collection<VirtualFile> files2 = XmlTagNamesIndex.getFilesByTagName(tagName, project);
        LinkedHashSet<String> possibleUris = new LinkedHashSet<String>(files2.size());
        for (VirtualFile virtualFile2 : files2) {
            String namespace = XmlNamespaceIndex.getNamespace(virtualFile2, project, file2);
            if (namespace == null) continue;
            possibleUris.add(namespace);
        }
        return possibleUris;
    }

    @Override
    @NotNull
    public Set<String> getNamespacesByTagName(@NotNull String tagName, @NotNull XmlFile context) {
        if (tagName == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(7);
        }
        if (context == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(8);
        }
        List<XmlSchemaProvider> providers = XmlSchemaProvider.getAvailableProviders(context);
        HashSet<String> set = new HashSet<String>();
        for (XmlSchemaProvider provider : providers) {
            set.addAll(provider.getAvailableNamespaces(context, tagName));
        }
        HashSet<String> hashSet = set;
        if (hashSet == null) {
            DefaultXmlNamespaceHelper.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleNamespaces";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/DefaultXmlNamespaceHelper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/DefaultXmlNamespaceHelper";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "guessUnboundNamespaces";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacesByTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertNamespaceDeclaration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "guessUnboundNamespaces";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacesByTagName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

