/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.JdomKt;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashSet;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTMLControls {
    private static final Logger LOG = Logger.getInstance(HTMLControls.class);
    private static Control[] ourControls;

    public static Control[] getControls() {
        if (ourControls == null) {
            ourControls = HTMLControls.loadControls();
        }
        return ourControls;
    }

    private static Control[] loadControls() {
        Element element;
        try {
            InputStream stream2 = HTMLControls.class.getResourceAsStream("HtmlControls.xml");
            byte[] bytes = FileUtilRt.loadBytes(stream2);
            stream2.close();
            UnsyncByteArrayInputStream bytesStream = new UnsyncByteArrayInputStream(bytes);
            element = JdomKt.loadElement(CharsetToolkit.inputStreamSkippingBOM(bytesStream));
            bytesStream.close();
        }
        catch (Exception e) {
            LOG.error(e);
            return new Control[0];
        }
        if (!element.getName().equals("htmlControls")) {
            LOG.error("HTMLControls storage is broken");
            return new Control[0];
        }
        return XmlSerializer.deserialize(element, Control[].class);
    }

    private static class AutoCloseConverter
    extends Converter<Set<String>> {
        private AutoCloseConverter() {
        }

        @Override
        @Nullable
        public Set<String> fromString(@NotNull String value) {
            if (value == null) {
                AutoCloseConverter.$$$reportNull$$$0(0);
            }
            THashSet<String> result2 = new THashSet<String>();
            for (String closingTag : StringUtil.split(value, ",")) {
                result2.add(closingTag.trim().toLowerCase(Locale.US));
            }
            return result2;
        }

        @Override
        @NotNull
        public String toString(@NotNull Set<String> o) {
            if (o == null) {
                AutoCloseConverter.$$$reportNull$$$0(1);
            }
            String string = StringUtil.join(o, ", ");
            if (string == null) {
                AutoCloseConverter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/util/HTMLControls$AutoCloseConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/util/HTMLControls$AutoCloseConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TagStateConverter
    extends Converter<TagState> {
        private TagStateConverter() {
        }

        @Override
        @Nullable
        public TagState fromString(@NotNull String value) {
            if (value == null) {
                TagStateConverter.$$$reportNull$$$0(0);
            }
            return TagState.valueOf(value.toUpperCase(Locale.US));
        }

        @Override
        @NotNull
        public String toString(@NotNull TagState state2) {
            if (state2 == null) {
                TagStateConverter.$$$reportNull$$$0(1);
            }
            String string = state2.name().toLowerCase(Locale.US);
            if (string == null) {
                TagStateConverter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/util/HTMLControls$TagStateConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/util/HTMLControls$TagStateConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="control")
    public static class Control {
        @Attribute(value="name")
        public String name;
        @Attribute(value="startTag", converter=TagStateConverter.class)
        public TagState startTag;
        @Attribute(value="endTag", converter=TagStateConverter.class)
        public TagState endTag;
        @Attribute(value="emptyAllowed")
        public boolean emptyAllowed;
        @Attribute(value="autoClosedBy", converter=AutoCloseConverter.class)
        public Set<String> autoClosedBy = Collections.emptySet();
    }

    public static enum TagState {
        REQUIRED,
        OPTIONAL,
        FORBIDDEN;

    }
}

