/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.RemoveAttributeIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.RoleFinder;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlTagRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlTagRuleProviderBase
extends XmlTagRuleProvider {
    public static RequireAttributeOneOf requireAttr(String ... attributeNames) {
        return new RequireAttributeOneOf(attributeNames);
    }

    public static ShouldHaveParams shouldHaveParams() {
        return new ShouldHaveParams();
    }

    public static XmlTagRuleProvider.Rule unusedIfPresent(String attrPresent, String ... attrUnused) {
        Effect[] effects = new Effect[attrUnused.length];
        for (int i = 0; i < effects.length; ++i) {
            effects[i] = XmlTagRuleProviderBase.unused(attrUnused[i], "The attribute '" + attrUnused[i] + "' is unused because the attribute '" + attrPresent + "' is present");
        }
        return new ConditionRule(XmlTagRuleProviderBase.ifAttrPresent(attrPresent), effects);
    }

    public static XmlTagRuleProvider.Rule unusedAllIfPresent(String attrPresent, String ... attrUnused) {
        return new ConditionRule(XmlTagRuleProviderBase.ifAttrPresent(attrPresent), new InvalidAllExpectSome("The attribute is unused because the attribute " + attrPresent + " is present", ProblemHighlightType.LIKE_UNUSED_SYMBOL, ArrayUtil.append(attrUnused, attrPresent)));
    }

    public static Effect invalid(String attrName, String text2) {
        return new InvalidAttrEffect(attrName, text2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    public static Effect unused(String attrName) {
        return new InvalidAttrEffect(attrName, "Attribute '" + attrName + "' is unused", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
    }

    public static Effect unused(String attrName, String text2) {
        return new InvalidAttrEffect(attrName, text2, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
    }

    public static Effect unusedAll(String text2, String ... attrNames) {
        return new InvalidAllExpectSome(text2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, attrNames);
    }

    public static XmlTagRuleProvider.Rule rule(Condition<XmlTag> condition, Effect ... effect) {
        return new ConditionRule(condition, effect);
    }

    @Nullable
    public static PsiElement getXmlElement(RoleFinder roleFinder, XmlElement tag) {
        ASTNode tagNode = tag.getNode();
        if (tagNode == null) {
            return null;
        }
        ASTNode nameElement = roleFinder.findChild(tagNode);
        if (nameElement == null) {
            return null;
        }
        return nameElement.getPsi();
    }

    @Nullable
    public static PsiElement getTagNameElement(XmlTag tag) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.START_TAG_NAME_FINDER, tag);
    }

    @Nullable
    public static PsiElement getAttributeNameElement(XmlAttribute attribute) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.ATTRIBUTE_NAME_FINDER, attribute);
    }

    public static boolean isClosedTag(XmlTag tag) {
        return XmlTagRuleProviderBase.getXmlElement(XmlChildRole.EMPTY_TAG_END_FINDER, tag) != null || XmlTagRuleProviderBase.getXmlElement(XmlChildRole.CLOSING_TAG_START_FINDER, tag) != null;
    }

    public static Condition<XmlTag> ifAttrPresent(String attrName) {
        return tag -> tag.getAttribute(attrName) != null;
    }

    public static class RequireAttributeOneOf
    extends ShouldHaveParams {
        private final String[] myAttributeNames;
        private final ProblemHighlightType myProblemHighlightType;

        public RequireAttributeOneOf(String ... attributeNames) {
            this.myAttributeNames = attributeNames;
            this.myProblemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }

        public RequireAttributeOneOf(@NotNull ProblemHighlightType problemHighlightType, String ... attributeNames) {
            if (problemHighlightType == null) {
                RequireAttributeOneOf.$$$reportNull$$$0(0);
            }
            assert (attributeNames.length > 0);
            this.myAttributeNames = attributeNames;
            this.myProblemHighlightType = problemHighlightType;
        }

        public String[] getAttributeNames() {
            return this.myAttributeNames;
        }

        @Override
        public void annotate(@NotNull XmlTag tag, @NotNull ProblemsHolder holder) {
            if (tag == null) {
                RequireAttributeOneOf.$$$reportNull$$$0(1);
            }
            if (holder == null) {
                RequireAttributeOneOf.$$$reportNull$$$0(2);
            }
            for (String attributeName : this.myAttributeNames) {
                if (tag.getAttribute(attributeName) == null) continue;
                return;
            }
            if (!XmlTagRuleProviderBase.isClosedTag(tag)) {
                return;
            }
            PsiElement tagNameElement = XmlTagRuleProviderBase.getTagNameElement(tag);
            if (tagNameElement == null) {
                return;
            }
            LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
            if (holder.isOnTheFly()) {
                fixes = new LocalQuickFix[this.myAttributeNames.length];
                for (int i = 0; i < this.myAttributeNames.length; ++i) {
                    fixes[i] = XmlQuickFixFactory.getInstance().insertRequiredAttributeFix(tag, this.myAttributeNames[i], new String[0]);
                }
            }
            holder.registerProblem(tagNameElement, "Tag should have one of following attributes: " + StringUtil.join(this.myAttributeNames, ", "), this.myProblemHighlightType, fixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemHighlightType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xml/util/XmlTagRuleProviderBase$RequireAttributeOneOf";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "annotate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ShouldHaveParams
    extends XmlTagRuleProvider.Rule {
        @Override
        public boolean needAtLeastOneAttribute(@NotNull XmlTag tag) {
            if (tag == null) {
                ShouldHaveParams.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/XmlTagRuleProviderBase$ShouldHaveParams", "needAtLeastOneAttribute"));
        }
    }

    public static class ConditionRule
    extends XmlTagRuleProvider.Rule {
        private final Condition<XmlTag> myCondition;
        private final Effect[] myEffect;

        public ConditionRule(Condition<XmlTag> condition, Effect ... effect) {
            this.myCondition = condition;
            this.myEffect = effect;
        }

        @Override
        public void annotate(@NotNull XmlTag tag, @NotNull ProblemsHolder holder) {
            if (tag == null) {
                ConditionRule.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                ConditionRule.$$$reportNull$$$0(1);
            }
            if (this.myCondition.value(tag)) {
                for (Effect effect : this.myEffect) {
                    effect.annotate(tag, holder);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/util/XmlTagRuleProviderBase$ConditionRule";
            objectArray[2] = "annotate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InvalidAllExpectSome
    extends Effect {
        private final String[] myAttrNames;
        private final String myText;
        private final ProblemHighlightType myType;

        public InvalidAllExpectSome(String text2, ProblemHighlightType type2, String ... attrNames) {
            this.myAttrNames = attrNames;
            this.myText = text2;
            this.myType = type2;
        }

        @Override
        public void annotate(@NotNull XmlTag tag, @NotNull ProblemsHolder holder) {
            if (tag == null) {
                InvalidAllExpectSome.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InvalidAllExpectSome.$$$reportNull$$$0(1);
            }
            for (XmlAttribute xmlAttribute : tag.getAttributes()) {
                PsiElement attributeNameElement;
                String attrName = xmlAttribute.getName();
                if (ArrayUtil.contains(attrName, this.myAttrNames) || (attributeNameElement = XmlTagRuleProviderBase.getAttributeNameElement(xmlAttribute)) == null) continue;
                holder.registerProblem(attributeNameElement, this.myText, this.myType, new RemoveAttributeIntentionAction(attrName));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/util/XmlTagRuleProviderBase$InvalidAllExpectSome";
            objectArray[2] = "annotate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InvalidAttrEffect
    extends Effect {
        private final String myAttrName;
        private final String myText;
        private final ProblemHighlightType myType;

        public InvalidAttrEffect(String attrName, String text2, ProblemHighlightType type2) {
            this.myAttrName = attrName;
            this.myText = text2;
            this.myType = type2;
        }

        @Override
        public void annotate(@NotNull XmlTag tag, @NotNull ProblemsHolder holder) {
            PsiElement attributeNameElement;
            XmlAttribute attribute;
            if (tag == null) {
                InvalidAttrEffect.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InvalidAttrEffect.$$$reportNull$$$0(1);
            }
            if ((attribute = tag.getAttribute(this.myAttrName)) != null && (attributeNameElement = XmlTagRuleProviderBase.getAttributeNameElement(attribute)) != null) {
                holder.registerProblem(attributeNameElement, this.myText, this.myType, new RemoveAttributeIntentionAction(this.myAttrName));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/util/XmlTagRuleProviderBase$InvalidAttrEffect";
            objectArray[2] = "annotate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Effect {
        public abstract void annotate(@NotNull XmlTag var1, @NotNull ProblemsHolder var2);
    }
}

