/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class MimeTypeDictionary {
    private static Set<String> ourContentTypes;

    public static Collection<String> getContentTypes() {
        if (ourContentTypes == null) {
            ourContentTypes = MimeTypeDictionary.loadContentTypes();
        }
        return ourContentTypes;
    }

    private static Set<String> loadContentTypes() {
        TreeSet<String> result2 = new TreeSet<String>();
        result2.add("*/*");
        MimeTypeDictionary.readMediaTypes(result2, "application");
        MimeTypeDictionary.readMediaTypes(result2, "audio");
        MimeTypeDictionary.readMediaTypes(result2, "image");
        MimeTypeDictionary.readMediaTypes(result2, "message");
        MimeTypeDictionary.readMediaTypes(result2, "model");
        MimeTypeDictionary.readMediaTypes(result2, "multipart");
        MimeTypeDictionary.readMediaTypes(result2, "text");
        MimeTypeDictionary.readMediaTypes(result2, "video");
        return result2;
    }

    private static void readMediaTypes(TreeSet<String> result2, String category) {
        String[] lines;
        InputStream stream2 = MimeTypeDictionary.class.getResourceAsStream("mimeTypes/" + category + ".csv");
        String csv = "";
        try {
            csv = stream2 != null ? FileUtil.loadTextAndClose(stream2) : "";
        }
        catch (IOException e) {
            Logger.getInstance(MimeTypeDictionary.class).error(e);
        }
        for (String line : lines = StringUtil.splitByLines(csv)) {
            String[] split;
            if (line == lines[0] || (split = line.split(",")).length <= 1) continue;
            result2.add(!split[1].isEmpty() ? split[1] : MimeTypeDictionary.withCategory(category, split[0]));
        }
    }

    private static String withCategory(String category, String name) {
        int whitespacePosition = name.indexOf(32);
        return category + "/" + (whitespacePosition > 0 ? name.substring(0, whitespacePosition) : name);
    }
}

