/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanParameterInspection
extends BaseInspection {
    public boolean onlyReportMultiple = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.parameter.display.name", new Object[0]);
        if (string == null) {
            BooleanParameterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiMethod method = (PsiMethod)infos2[0];
        int booleanParameterCount = (Integer)infos2[1];
        if (booleanParameterCount == 1) {
            String string = method.isConstructor() ? InspectionGadgetsBundle.message("boolean.parameter.constructor.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("boolean.parameter.problem.descriptor", new Object[0]);
            if (string == null) {
                BooleanParameterInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = method.isConstructor() ? InspectionGadgetsBundle.message("boolean.parameters.constructor.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("boolean.parameters.problem.descriptor", new Object[0]);
        if (string == null) {
            BooleanParameterInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("boolean.parameter.only.report.multiple.option", new Object[0]), this, "onlyReportMultiple");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/BooleanParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class BooleanParameterVisitor
    extends BaseInspectionVisitor {
        private BooleanParameterVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            PsiParameter parameter;
            PsiType type2;
            PsiClass aClass2;
            super.visitMethod(method);
            if (!(method.hasModifierProperty("public") || (aClass2 = method.getContainingClass()) != null && aClass2.isInterface())) {
                return;
            }
            if (PropertyUtilBase.isSimplePropertySetter(method) || LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            int count2 = 0;
            PsiParameter[] psiParameterArray = parameters2;
            int n = psiParameterArray.length;
            for (int i = 0; !(i >= n || PsiType.BOOLEAN.equals(type2 = (parameter = psiParameterArray[i]).getType()) && ++count2 > 1); ++i) {
            }
            if (count2 == 0 || BooleanParameterInspection.this.onlyReportMultiple && count2 == 1) {
                return;
            }
            this.registerMethodError(method, method, count2);
        }
    }
}

