/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CastToConcreteClassInspection
extends BaseInspection {
    public boolean ignoreAbstractClasses = false;
    public boolean ignoreInEquals = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.to.concrete.class.display.name", new Object[0]);
        if (string == null) {
            CastToConcreteClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiType type2 = (PsiType)infos2[0];
        String string = InspectionGadgetsBundle.message("cast.to.concrete.class.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            CastToConcreteClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("cast.to.concrete.class.option", new Object[0]), "ignoreAbstractClasses");
        panel.addCheckbox(InspectionGadgetsBundle.message("cast.to.concrete.class.ignore.equals.option", new Object[0]), "ignoreInEquals");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastToConcreteClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/CastToConcreteClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CastToConcreteClassVisitor
    extends BaseInspectionVisitor {
        private CastToConcreteClassVisitor() {
        }

        @Override
        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
            if (expression2 == null) {
                CastToConcreteClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression2);
            PsiTypeElement typeElement = expression2.getCastType();
            if (typeElement == null) {
                return;
            }
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement, CastToConcreteClassInspection.this.ignoreAbstractClasses)) {
                return;
            }
            PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, true, PsiClass.class, PsiLambdaExpression.class);
            if (MethodUtils.isEquals(method) || CloneUtils.isClone(method)) {
                return;
            }
            this.registerError((PsiElement)typeElement, typeElement.getType());
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"cast".equals(referenceName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (!"java.lang.Class".equals(TypeUtils.resolvedClassName(type2))) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiType[] parameters2 = classType.getParameters();
            if (parameters2.length != 1) {
                return;
            }
            PsiType parameter = parameters2[0];
            if (!ConcreteClassUtil.typeIsConcreteClass(parameter, CastToConcreteClassInspection.this.ignoreAbstractClasses)) {
                return;
            }
            PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, true, PsiClass.class, PsiLambdaExpression.class);
            if (MethodUtils.isEquals(method) || CloneUtils.isClone(method)) {
                return;
            }
            this.registerMethodCallError(expression2, parameter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/CastToConcreteClassInspection$CastToConcreteClassVisitor", "visitTypeCastExpression"));
        }
    }
}

