/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InstanceofChainInspection
extends BaseInspection {
    public boolean ignoreInstanceofOnLibraryClasses = false;

    @Override
    @NotNull
    public String getID() {
        if ("ChainOfInstanceofChecks" == null) {
            InstanceofChainInspection.$$$reportNull$$$0(0);
        }
        return "ChainOfInstanceofChecks";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("chain.of.instanceof.checks.display.name", new Object[0]);
        if (string == null) {
            InstanceofChainInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        Check check2 = (Check)((Object)infos2[0]);
        if (check2 == Check.CLASS_EQUALITY) {
            String string = InspectionGadgetsBundle.message("chain.of.class.equality.checks.problem.descriptor", new Object[0]);
            if (string == null) {
                InstanceofChainInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("chain.of.instanceof.checks.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceofChainInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.instanceof.on.library.classes", new Object[0]), this, "ignoreInstanceofOnLibraryClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofChainVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/InstanceofChainInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class InstanceofChainVisitor
    extends BaseInspectionVisitor {
        private InstanceofChainVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            PsiIfStatement previousIfStatement;
            PsiExpression condition;
            if (ifStatement == null) {
                InstanceofChainVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(ifStatement);
            if (ControlFlowUtils.isElseIf(ifStatement)) {
                return;
            }
            PsiStatement previousStatement = PsiTreeUtil.getPrevSiblingOfType(ifStatement, PsiStatement.class);
            if (previousStatement instanceof PsiIfStatement && this.chainCheck(condition = (previousIfStatement = (PsiIfStatement)previousStatement).getCondition(), null) != Check.NEITHER) {
                return;
            }
            int numChecks = 0;
            PsiIfStatement branch = ifStatement;
            Check check2 = null;
            while (true) {
                PsiStatement nextStatement;
                PsiExpression condition2;
                Check chainCheck;
                if ((chainCheck = this.chainCheck(condition2 = branch.getCondition(), check2)) == Check.NEITHER) {
                    if (numChecks > 1) break;
                    return;
                }
                check2 = chainCheck;
                ++numChecks;
                PsiStatement elseBranch = branch.getElseBranch();
                if (elseBranch instanceof PsiIfStatement) {
                    branch = (PsiIfStatement)elseBranch;
                    continue;
                }
                if (elseBranch != null || !((nextStatement = PsiTreeUtil.getNextSiblingOfType(branch, PsiStatement.class)) instanceof PsiIfStatement)) break;
                branch = (PsiIfStatement)nextStatement;
            }
            if (numChecks < 2) {
                return;
            }
            this.registerStatementError(ifStatement, new Object[]{check2});
        }

        private Check chainCheck(PsiExpression condition, Check check2) {
            while (true) {
                if (condition == null) {
                    return Check.NEITHER;
                }
                if (check2 != Check.CLASS_EQUALITY && this.isInstanceofExpression(condition)) {
                    return Check.INSTANCEOF;
                }
                if (condition instanceof PsiPolyadicExpression) {
                    PsiExpression[] operands;
                    if (check2 != Check.INSTANCEOF && this.isClassEqualityExpression(condition)) {
                        return Check.CLASS_EQUALITY;
                    }
                    PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
                    for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                        Check chainCheck = this.chainCheck(operand, check2);
                        if (chainCheck == Check.NEITHER) continue;
                        return chainCheck;
                    }
                    return Check.NEITHER;
                }
                if (condition instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                    condition = parenthesizedExpression.getExpression();
                    continue;
                }
                if (!(condition instanceof PsiUnaryExpression)) break;
                PsiUnaryExpression unaryOperation = (PsiUnaryExpression)condition;
                condition = unaryOperation.getOperand();
            }
            return Check.NEITHER;
        }

        private boolean isClassEqualityExpression(PsiExpression expression2) {
            if (!(expression2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            if (binaryExpression.getOperationTokenType() != JavaTokenType.EQEQ) {
                return false;
            }
            return this.isClassObjectAccessExpression(binaryExpression.getLOperand()) || this.isClassObjectAccessExpression(binaryExpression.getROperand());
        }

        private boolean isClassObjectAccessExpression(PsiExpression expression2) {
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiClassObjectAccessExpression)) {
                return false;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)expression2;
            PsiTypeElement typeElement = classObjectAccessExpression.getOperand();
            return !InstanceofChainInspection.this.ignoreInstanceofOnLibraryClasses || !LibraryUtil.isTypeInLibrary(typeElement.getType());
        }

        private boolean isInstanceofExpression(PsiExpression expression2) {
            if (!(expression2 instanceof PsiInstanceOfExpression)) {
                return false;
            }
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            PsiTypeElement typeElement = instanceOfExpression.getCheckType();
            return !InstanceofChainInspection.this.ignoreInstanceofOnLibraryClasses || typeElement == null || !LibraryUtil.isTypeInLibrary(typeElement.getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/abstraction/InstanceofChainInspection$InstanceofChainVisitor", "visitIfStatement"));
        }
    }

    private static enum Check {
        CLASS_EQUALITY,
        INSTANCEOF,
        NEITHER;

    }
}

