/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import org.jetbrains.annotations.NotNull;

public class PublicMethodNotExposedInInterfaceInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean onlyWarnIfContainingClassImplementsAnInterface = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.method.not.in.interface.display.name", new Object[0]);
        if (string == null) {
            PublicMethodNotExposedInInterfaceInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("public.method.not.in.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            PublicMethodNotExposedInInterfaceInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos2) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)infos2[0], this.ignorableAnnotations);
        if (inspectionGadgetsFixArray == null) {
            PublicMethodNotExposedInInterfaceInspectionBase.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodNotExposedInInterfaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PublicMethodNotExposedInInterfaceVisitor
    extends BaseInspectionVisitor {
        private PublicMethodNotExposedInInterfaceVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                PublicMethodNotExposedInInterfaceVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!containingClass.hasModifierProperty("public")) {
                return;
            }
            if (AnnotationUtil.isAnnotated(method, PublicMethodNotExposedInInterfaceInspectionBase.this.ignorableAnnotations)) {
                return;
            }
            if (PublicMethodNotExposedInInterfaceInspectionBase.this.onlyWarnIfContainingClassImplementsAnInterface) {
                PsiClass[] superClasses2 = containingClass.getSupers();
                boolean implementsInterface = false;
                for (PsiClass superClass : superClasses2) {
                    if (!superClass.isInterface() || LibraryUtil.classIsInLibrary(superClass)) continue;
                    implementsInterface = true;
                    break;
                }
                if (!implementsInterface) {
                    return;
                }
            }
            if (this.exposedInInterface(method)) {
                return;
            }
            if (TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }

        private boolean exposedInInterface(PsiMethod method) {
            PsiMethod[] superMethods = method.findSuperMethods();
            PsiMethod siblingInherited = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method);
            if (siblingInherited != null && !ArrayUtil.contains(siblingInherited, superMethods)) {
                superMethods = ArrayUtil.append(superMethods, siblingInherited);
            }
            for (PsiMethod superMethod : superMethods) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null) continue;
                if (superClass.isInterface()) {
                    return true;
                }
                String superclassName = superClass.getQualifiedName();
                if ("java.lang.Object".equals(superclassName)) {
                    return true;
                }
                if (!this.exposedInInterface(superMethod)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspectionBase$PublicMethodNotExposedInInterfaceVisitor", "visitMethod"));
        }
    }
}

