/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConstantAssertConditionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.assert.condition.display.name", new Object[0]);
        if (string == null) {
            ConstantAssertConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("constant.assert.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantAssertConditionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantAssertConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ConstantAssertConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantAssertConditionVisitor
    extends BaseInspectionVisitor {
        private ConstantAssertConditionVisitor() {
        }

        @Override
        public void visitAssertStatement(PsiAssertStatement statement2) {
            super.visitAssertStatement(statement2);
            PsiExpression assertCondition = statement2.getAssertCondition();
            PsiExpression expression2 = ParenthesesUtils.stripParentheses(assertCondition);
            if (expression2 == null) {
                return;
            }
            if (BoolUtils.isFalse(expression2)) {
                return;
            }
            if (!PsiUtil.isConstantExpression(expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

