/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitArrayToStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.array.to.string.display.name", new Object[0]);
        if (string == null) {
            ImplicitArrayToStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        if (((Boolean)infos2[1]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("explicit.array.to.string.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitArrayToStringInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (infos2[0] instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.method.call.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitArrayToStringInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("implicit.array.to.string.problem.descriptor", new Object[0]);
        if (string == null) {
            ImplicitArrayToStringInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiType componentType;
        PsiExpression expression2 = (PsiExpression)infos2[0];
        boolean removeToString = (Boolean)infos2[1];
        PsiArrayType type2 = (PsiArrayType)expression2.getType();
        if (type2 != null && (componentType = type2.getComponentType()) instanceof PsiArrayType) {
            return new ImplicitArrayToStringFix(true, removeToString);
        }
        return new ImplicitArrayToStringFix(false, removeToString);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitArrayToStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ImplicitArrayToStringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ImplicitArrayToStringVisitor
    extends BaseInspectionVisitor {
        private ImplicitArrayToStringVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall(expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, Boolean.FALSE);
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall(expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, Boolean.FALSE);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (ImplicitArrayToStringVisitor.isExplicitArrayToStringCall(expression2)) {
                PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                this.registerMethodCallError(expression2, qualifier, Boolean.TRUE);
                return;
            }
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall(expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, Boolean.FALSE);
        }

        private static boolean isExplicitArrayToStringCall(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName)) {
                return false;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length != 0) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type2 = qualifier.getType();
            return type2 instanceof PsiArrayType;
        }

        private static boolean isImplicitArrayToStringCall(PsiExpression expression2) {
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return false;
            }
            if (ExpressionUtils.isStringConcatenationOperand(expression2)) {
                return true;
            }
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiExpressionList) {
                String qualifiedName2;
                PsiExpressionList expressionList = (PsiExpressionList)parent2;
                PsiArrayType arrayType = (PsiArrayType)type2;
                PsiType componentType = arrayType.getComponentType();
                if (componentType.equals(PsiType.CHAR)) {
                    return false;
                }
                PsiElement grandParent = expressionList.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiExpression[] arguments2 = expressionList.getExpressions();
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return false;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return false;
                }
                if ("append".equals(methodName)) {
                    if (arguments2.length != 1) {
                        return false;
                    }
                    return InheritanceUtil.isInheritor(containingClass, "java.lang.AbstractStringBuilder");
                }
                if ("valueOf".equals(methodName)) {
                    if (arguments2.length != 1) {
                        return false;
                    }
                    String qualifiedName3 = containingClass.getQualifiedName();
                    return "java.lang.String".equals(qualifiedName3);
                }
                if (!"print".equals(methodName) && !"println".equals(methodName)) {
                    if (!"printf".equals(methodName) && !"format".equals(methodName)) {
                        return false;
                    }
                    if (arguments2.length < 1) {
                        return false;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    PsiParameter[] parameters2 = parameterList.getParameters();
                    PsiParameter parameter = parameters2[0];
                    PsiType firstParameterType = parameter.getType();
                    if (firstParameterType.equalsToText("java.util.Locale") ? arguments2.length < 4 : arguments2.length < 3) {
                        return false;
                    }
                }
                if ("java.util.Formatter".equals(qualifiedName2 = containingClass.getQualifiedName()) || "java.lang.String".equals(qualifiedName2)) {
                    return true;
                }
                if (InheritanceUtil.isInheritor(containingClass, "java.io.PrintStream")) {
                    return true;
                }
                if (InheritanceUtil.isInheritor(containingClass, "java.io.PrintWriter")) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class ImplicitArrayToStringFix
    extends InspectionGadgetsFix {
        private final boolean deepString;
        private final boolean removeToString;

        ImplicitArrayToStringFix(boolean deepString, boolean removeToString) {
            this.deepString = deepString;
            this.removeToString = removeToString;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Make Array.toString() implicit" == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(0);
            }
            return "Make Array.toString() implicit";
        }

        @Override
        @NotNull
        public String getName() {
            String expressionText = this.deepString ? "java.util.Arrays.deepToString()" : "java.util.Arrays.toString()";
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.quickfix", expressionText);
            if (string == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiMethodCallExpression methodCallExpression;
            PsiReferenceExpression methodExpression;
            PsiElement grandParent;
            String expressionText;
            PsiElement element = descriptor2.getPsiElement();
            PsiExpression expression2 = element instanceof PsiExpression ? (PsiExpression)element : (PsiExpression)element.getParent().getParent();
            if (this.removeToString) {
                PsiMethodCallExpression methodCallExpression2 = (PsiMethodCallExpression)expression2;
                PsiReferenceExpression methodExpression2 = methodCallExpression2.getMethodExpression();
                PsiExpression qualifier = methodExpression2.getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                expressionText = qualifier.getText();
            } else {
                expressionText = expression2.getText();
            }
            String newExpressionText = this.deepString ? "java.util.Arrays.deepToString(" + expressionText + ')' : "java.util.Arrays.toString(" + expressionText + ')';
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiExpressionList && (grandParent = parent2.getParent()) instanceof PsiMethodCallExpression && "valueOf".equals((methodExpression = (methodCallExpression = (PsiMethodCallExpression)grandParent).getMethodExpression()).getReferenceName())) {
                PsiReplacementUtil.replaceExpressionAndShorten(methodCallExpression, newExpressionText);
                return;
            }
            PsiReplacementUtil.replaceExpressionAndShorten(expression2, newExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/ImplicitArrayToStringInspection$ImplicitArrayToStringFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

