/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class MalformedRegexInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.regular.expression.display.name", new Object[0]);
        if (string == null) {
            MalformedRegexInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        if (infos2.length == 0) {
            String string = InspectionGadgetsBundle.message("malformed.regular.expression.problem.descriptor1", new Object[0]);
            if (string == null) {
                MalformedRegexInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("malformed.regular.expression.problem.descriptor2", infos2[0]);
        if (string == null) {
            MalformedRegexInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedRegexVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/MalformedRegexInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MalformedRegexVisitor
    extends BaseInspectionVisitor {
        private MalformedRegexVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                MalformedRegexVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(methodCallExpression);
            if (!MethodCallUtils.isCallToRegexMethod(methodCallExpression)) {
                return;
            }
            PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments2[0];
            if (!ExpressionUtils.hasStringType(firstArgument)) {
                return;
            }
            String value = (String)ExpressionUtils.computeConstantExpression(firstArgument);
            if (value == null) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if ("compile".equals(methodExpression.getReferenceName()) && arguments2.length == 2) {
                PsiExpression secondArgument = arguments2[1];
                Object flags = ExpressionUtils.computeConstantExpression(secondArgument);
                if (flags instanceof Integer) {
                    try {
                        Pattern.compile(value, (Integer)flags);
                    }
                    catch (PatternSyntaxException e) {
                        this.registerError((PsiElement)firstArgument, e.getDescription());
                    }
                    catch (NullPointerException e) {
                        this.registerError((PsiElement)firstArgument, new Object[0]);
                    }
                }
                return;
            }
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                this.registerError((PsiElement)firstArgument, e.getDescription());
            }
            catch (NullPointerException e) {
                this.registerError((PsiElement)firstArgument, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/siyeh/ig/bugs/MalformedRegexInspection$MalformedRegexVisitor", "visitMethodCallExpression"));
        }
    }
}

