/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashSet;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedXPathInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> xpathMethodNames = new HashSet<String>(2);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.xpath.expression.display.name", new Object[0]);
        if (string == null) {
            MalformedXPathInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("malformed.xpath.expression.problem.description", new Object[0]);
        if (string == null) {
            MalformedXPathInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedXPathVisitor();
    }

    static {
        xpathMethodNames.add("compile");
        xpathMethodNames.add("evaluate");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/MalformedXPathInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MalformedXPathVisitor
    extends BaseInspectionVisitor {
        private MalformedXPathVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                MalformedXPathVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length == 0) {
                return;
            }
            PsiExpression xpathArgument = arguments2[0];
            if (!ExpressionUtils.hasStringType(xpathArgument)) {
                return;
            }
            if (!PsiUtil.isConstantExpression(xpathArgument)) {
                return;
            }
            PsiType type2 = xpathArgument.getType();
            if (type2 == null) {
                return;
            }
            String value = (String)ConstantExpressionUtil.computeCastTo(xpathArgument, type2);
            if (value == null) {
                return;
            }
            if (!MalformedXPathVisitor.callTakesXPathExpression(expression2)) {
                return;
            }
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            try {
                xpath.compile(value);
            }
            catch (XPathExpressionException ignore) {
                this.registerError((PsiElement)xpathArgument, new Object[0]);
            }
        }

        private static boolean callTakesXPathExpression(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!xpathMethodNames.contains(name)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className2 = containingClass.getQualifiedName();
            return "javax.xml.xpath.XPath".equals(className2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/MalformedXPathInspection$MalformedXPathVisitor", "visitMethodCallExpression"));
        }
    }
}

