/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.CollectionQueryUpdateCalledVisitor;
import com.siyeh.ig.bugs.ThisPassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MismatchedCollectionQueryUpdateInspectionBase
extends BaseInspection {
    static final Set<String> QUERY_EXCLUDES = Collections.singleton("java.util.Collections");
    static final Set<String> UPDATE_EXCLUDES = new HashSet<String>(CollectionUtils.getAllCollectionNames());
    public final ExternalizableStringSet queryNames = new ExternalizableStringSet("compute", "copyInto", "drainTo", "forEach", "parallelStream", "propertyNames", "replaceAll", "save", "store", "stream", "toArray", "write");
    public final ExternalizableStringSet updateNames = new ExternalizableStringSet("add", "clear", "compute", "drainTo", "insert", "load", "merge", "offer", "poll", "push", "put", "remove", "replace", "retain", "set", "take");
    public final ExternalizableStringSet ignoredClasses = new ExternalizableStringSet(new String[0]);

    static boolean isEmptyCollectionInitializer(PsiExpression initializer2) {
        PsiExpression[] arguments2;
        if (!(initializer2 instanceof PsiNewExpression)) {
            return ConstructionUtils.isEmptyCollectionInitializer(initializer2);
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer2;
        PsiExpressionList argumentList2 = newExpression.getArgumentList();
        if (argumentList2 == null) {
            return false;
        }
        for (PsiExpression argument : arguments2 = argumentList2.getExpressions()) {
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return false;
            }
            if (CollectionUtils.isCollectionClassOrInterface(argumentType)) {
                return false;
            }
            if (!(argumentType instanceof PsiArrayType)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("MismatchedQueryAndUpdateOfCollection" == null) {
            MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(0);
        }
        return "MismatchedQueryAndUpdateOfCollection";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.update.collection.display.name", new Object[0]);
        if (string == null) {
            MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        boolean updated = (Boolean)infos2[0];
        if (updated) {
            String string = InspectionGadgetsBundle.message("mismatched.update.collection.problem.descriptor.updated.not.queried", new Object[0]);
            if (string == null) {
                MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.update.collection.problem.description.queried.not.updated", new Object[0]);
        if (string == null) {
            MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedCollectionQueryUpdateVisitor();
    }

    static {
        UPDATE_EXCLUDES.add("java.util.Collections");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UpdateCallProcessor
    implements Processor<PsiCall> {
        private UpdateCallProcessor() {
        }

        @Override
        public boolean process(PsiCall call2) {
            PsiMethod method = call2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null || !UPDATE_EXCLUDES.contains(aClass2.getQualifiedName())) {
                return false;
            }
            return !"drainTo".equals(method.getName()) || !InheritanceUtil.isInheritor(aClass2, "java.util.concurrent.BlockingQueue");
        }
    }

    private static class QueryCallProcessor
    implements Processor<PsiCall> {
        private QueryCallProcessor() {
        }

        @Override
        public boolean process(PsiCall call2) {
            PsiMethod method = call2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass2 = method.getContainingClass();
            return aClass2 != null && QUERY_EXCLUDES.contains(aClass2.getQualifiedName());
        }
    }

    private class MismatchedCollectionQueryUpdateVisitor
    extends BaseInspectionVisitor {
        private MismatchedCollectionQueryUpdateVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass(field);
            if (!this.checkVariable(field, containingClass)) {
                return;
            }
            boolean written = this.collectionContentsAreUpdated(field, containingClass);
            boolean read2 = this.collectionContentsAreQueried(field, containingClass);
            if (read2 == written || UnusedSymbolUtil.isImplicitWrite(field) || UnusedSymbolUtil.isImplicitRead(field)) {
                return;
            }
            this.registerFieldError(field, written);
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable2) {
            if (variable2 == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(1);
            }
            super.visitLocalVariable(variable2);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiCodeBlock.class);
            if (!this.checkVariable(variable2, codeBlock)) {
                return;
            }
            boolean written = this.collectionContentsAreUpdated(variable2, codeBlock);
            boolean read2 = this.collectionContentsAreQueried(variable2, codeBlock);
            if (read2 != written) {
                this.registerVariableError(variable2, written);
            }
        }

        private boolean checkVariable(PsiVariable variable2, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type2 = variable2.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type2)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable2, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable2, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsUsedInArrayInitializer(variable2, context)) {
                return false;
            }
            return MismatchedCollectionQueryUpdateInspectionBase.this.ignoredClasses.stream().noneMatch(className2 -> InheritanceUtil.isInheritor(type2, className2));
        }

        private boolean collectionContentsAreUpdated(PsiVariable variable2, PsiElement context) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable2, context, new UpdateCallProcessor()) || this.collectionUpdateCalled(variable2, context)) {
                return true;
            }
            PsiExpression initializer2 = variable2.getInitializer();
            if (initializer2 != null && !MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(initializer2)) {
                return true;
            }
            if (initializer2 instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)initializer2).getAnonymousClass()) != null) {
                if (this.collectionUpdateCalled(null, anonymousClass)) {
                    return true;
                }
                ThisPassedAsArgumentVisitor visitor2 = new ThisPassedAsArgumentVisitor();
                anonymousClass.accept(visitor2);
                if (visitor2.isPassed()) {
                    return true;
                }
            }
            return VariableAccessUtils.variableIsAssigned(variable2, context);
        }

        private boolean collectionContentsAreQueried(PsiVariable variable2, PsiElement context) {
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable2, context, new QueryCallProcessor()) || this.collectionQueryCalled(variable2, context)) {
                return true;
            }
            PsiExpression initializer2 = variable2.getInitializer();
            if (initializer2 != null && !MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(initializer2)) {
                return true;
            }
            return this.collectionQueriedByAssignment(variable2, context);
        }

        private boolean collectionQueryCalled(PsiVariable variable2, PsiElement context) {
            CollectionQueryUpdateCalledVisitor visitor2 = new CollectionQueryUpdateCalledVisitor(variable2, MismatchedCollectionQueryUpdateInspectionBase.this.queryNames, true);
            context.accept(visitor2);
            return visitor2.isQueriedUpdated();
        }

        private boolean collectionUpdateCalled(@Nullable PsiVariable variable2, PsiElement context) {
            CollectionQueryUpdateCalledVisitor visitor2 = new CollectionQueryUpdateCalledVisitor(variable2, MismatchedCollectionQueryUpdateInspectionBase.this.updateNames, false);
            context.accept(visitor2);
            return visitor2.isQueriedUpdated();
        }

        private boolean collectionQueriedByAssignment(@NotNull PsiVariable variable2, @NotNull PsiElement context) {
            if (variable2 == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(3);
            }
            CollectionQueriedByAssignmentVisitor visitor2 = new CollectionQueriedByAssignmentVisitor(variable2);
            context.accept(visitor2);
            return visitor2.mayBeQueried();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectionQueriedByAssignment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CollectionQueriedByAssignmentVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean mayBeQueried;
        @NotNull
        private final PsiVariable variable;

        CollectionQueriedByAssignmentVisitor(@NotNull PsiVariable variable2) {
            if (variable2 == null) {
                CollectionQueriedByAssignmentVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable2;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CollectionQueriedByAssignmentVisitor.$$$reportNull$$$0(1);
            }
            if (this.mayBeQueried) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.mayBeQueried) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(expression2);
            if (!(parent2 instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.PLUS != tokenType) {
                return;
            }
            PsiElement target = expression2.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            PsiType type2 = polyadicExpression.getType();
            if (type2 == null || !type2.equalsToText("java.lang.String")) {
                return;
            }
            this.mayBeQueried = true;
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                CollectionQueriedByAssignmentVisitor.$$$reportNull$$$0(2);
            }
            if (this.mayBeQueried) {
                return;
            }
            super.visitAssignmentExpression(assignment);
            PsiExpression lhs = assignment.getLExpression();
            if (!VariableAccessUtils.mayEvaluateToVariable(lhs, this.variable)) {
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(rhs)) {
                return;
            }
            this.mayBeQueried = true;
        }

        boolean mayBeQueried() {
            return this.mayBeQueried;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase$CollectionQueriedByAssignmentVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

