/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ReflectionForUnavailableAnnotationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("reflection.for.unavailable.annotation.display.name", new Object[0]);
        if (string == null) {
            ReflectionForUnavailableAnnotationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("reflection.for.unavailable.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            ReflectionForUnavailableAnnotationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReflectionForUnavailableAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReflectionForUnavailableAnnotationVisitor
    extends BaseInspectionVisitor {
        private ReflectionForUnavailableAnnotationVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiNameValuePair[] attributes;
            if (expression2 == null) {
                ReflectionForUnavailableAnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"isAnnotationPresent".equals(methodName) && !"getAnnotation".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] args = argumentList2.getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            if (arg == null) {
                return;
            }
            if (!(arg instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.reflect.AnnotatedElement")) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)arg;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiClass annotationClass = PsiTypesUtil.getPsiClass(operand.getType());
            if (annotationClass == null) {
                return;
            }
            PsiModifierList modifierList = annotationClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            PsiAnnotation retentionAnnotation = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnnotation == null) {
                this.registerError((PsiElement)arg, new Object[0]);
                return;
            }
            PsiAnnotationParameterList parameters2 = retentionAnnotation.getParameterList();
            for (PsiNameValuePair attribute : attributes = parameters2.getAttributes()) {
                String text2;
                PsiAnnotationMemberValue value;
                String name = attribute.getName();
                if (name != null && !"value".equals(name) || (value = attribute.getValue()) == null || (text2 = value.getText()).contains("RUNTIME")) continue;
                this.registerError((PsiElement)arg, new Object[0]);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ReflectionForUnavailableAnnotationInspection$ReflectionForUnavailableAnnotationVisitor", "visitMethodCallExpression"));
        }
    }
}

