/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class UseOfPropertiesAsHashtableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.display.name", new Object[0]);
        if (string == null) {
            UseOfPropertiesAsHashtableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.problem.descriptor", new Object[0]);
        if (string == null) {
            UseOfPropertiesAsHashtableInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiExpression[] arguments2;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos2[0];
        String methodName = methodCallExpression.getMethodExpression().getReferenceName();
        boolean put2 = "put".equals(methodName);
        if (!put2 && !"get".equals(methodName)) {
            return null;
        }
        PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
        for (PsiExpression argument : arguments2 = argumentList2.getExpressions()) {
            PsiType type2 = argument.getType();
            if (type2 != null && type2.equalsToText("java.lang.String")) continue;
            return null;
        }
        return new UseOfPropertiesAsHashtableFix(put2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfPropertiesAsHashtableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UseOfPropertiesAsHashtableVisitor
    extends BaseInspectionVisitor {
        private UseOfPropertiesAsHashtableVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                UseOfPropertiesAsHashtableVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("put".equals(methodName) || "putAll".equals(methodName) || "get".equals(methodName))) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor(containingClass, "java.util.Hashtable")) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Properties")) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection$UseOfPropertiesAsHashtableVisitor", "visitMethodCallExpression"));
        }
    }

    private static class UseOfPropertiesAsHashtableFix
    extends InspectionGadgetsFix {
        private final boolean put;

        public UseOfPropertiesAsHashtableFix(boolean put2) {
            this.put = put2;
        }

        @Override
        @NotNull
        public String getName() {
            if (this.put) {
                String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.set.quickfix", new Object[0]);
                if (string == null) {
                    UseOfPropertiesAsHashtableFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.get.quickfix", new Object[0]);
            if (string == null) {
                UseOfPropertiesAsHashtableFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Fix property access" == null) {
                UseOfPropertiesAsHashtableFix.$$$reportNull$$$0(2);
            }
            return "Fix property access";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent2 = element.getParent();
            PsiElement grandParent = parent2.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            StringBuilder newExpression = new StringBuilder();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null) {
                newExpression.append(qualifierExpression.getText());
                newExpression.append('.');
            }
            if (this.put) {
                newExpression.append("setProperty(");
            } else {
                newExpression.append("getProperty(");
            }
            PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            boolean first2 = true;
            for (PsiExpression argument : arguments2) {
                if (!first2) {
                    newExpression.append(',');
                } else {
                    first2 = false;
                }
                newExpression.append(argument.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpression(methodCallExpression, newExpression.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection$UseOfPropertiesAsHashtableFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

