/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInitializerInspection
extends BaseInspection {
    public boolean onlyWarnWhenConstructor = false;

    @Override
    @NotNull
    public String getID() {
        if ("NonStaticInitializer" == null) {
            ClassInitializerInspection.$$$reportNull$$$0(0);
        }
        return "NonStaticInitializer";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.initializer.display.name", new Object[0]);
        if (string == null) {
            ClassInitializerInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("class.initializer.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassInitializerInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.initializer.option", new Object[0]), this, "onlyWarnWhenConstructor");
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[0];
        if (PsiUtil.isInnerClass(aClass2)) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new MoveToConstructorFix()};
            if (inspectionGadgetsFixArray == null) {
                ClassInitializerInspection.$$$reportNull$$$0(3);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ChangeModifierFix("static"), new MoveToConstructorFix()};
        if (inspectionGadgetsFixArray == null) {
            ClassInitializerInspection.$$$reportNull$$$0(4);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassInitializerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/ClassInitializerInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassInitializerVisitor
    extends BaseInspectionVisitor {
        private ClassInitializerVisitor() {
        }

        @Override
        public void visitClassInitializer(PsiClassInitializer initializer2) {
            super.visitClassInitializer(initializer2);
            if (initializer2.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass2 = initializer2.getContainingClass();
            if (aClass2 == null || aClass2 instanceof PsiAnonymousClass) {
                return;
            }
            if (ClassInitializerInspection.this.onlyWarnWhenConstructor && aClass2.getConstructors().length == 0) {
                return;
            }
            this.registerClassInitializerError(initializer2, aClass2);
        }
    }

    private static class MoveToConstructorFix
    extends InspectionGadgetsFix {
        private MoveToConstructorFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("class.initializer.move.code.to.constructor.quickfix", new Object[0]);
            if (string == null) {
                MoveToConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement brace = descriptor2.getPsiElement();
            PsiElement parent2 = brace.getParent();
            if (!(parent2 instanceof PsiCodeBlock)) {
                return;
            }
            PsiElement grandParent = parent2.getParent();
            if (!(grandParent instanceof PsiClassInitializer)) {
                return;
            }
            PsiClassInitializer initializer2 = (PsiClassInitializer)grandParent;
            PsiClass aClass2 = initializer2.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            Collection<PsiMethod> constructors2 = MoveToConstructorFix.getOrCreateConstructors(aClass2);
            for (PsiMethod constructor : constructors2) {
                MoveToConstructorFix.addCodeToMethod(initializer2, constructor);
            }
            initializer2.delete();
        }

        private static void addCodeToMethod(PsiClassInitializer initializer2, PsiMethod constructor) {
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return;
            }
            PsiCodeBlock codeBlock = initializer2.getBody();
            PsiElement last2 = codeBlock.getLastBodyElement();
            for (PsiElement element = codeBlock.getFirstBodyElement(); element != null && element != last2; element = element.getNextSibling()) {
                body.add(element);
            }
        }

        @NotNull
        private static Collection<PsiMethod> getOrCreateConstructors(@NotNull PsiClass aClass2) {
            PsiMethod[] constructors2;
            if (aClass2 == null) {
                MoveToConstructorFix.$$$reportNull$$$0(1);
            }
            if ((constructors2 = aClass2.getConstructors()).length == 0) {
                LocalQuickFixAndIntentionActionOnPsiElement addDefaultConstructorFix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass2);
                addDefaultConstructorFix.invoke(aClass2.getProject(), null, aClass2.getContainingFile());
            }
            constructors2 = aClass2.getConstructors();
            Collection<PsiMethod> collection = MoveToConstructorFix.removeChainedConstructors(ContainerUtil.newArrayList(constructors2));
            if (collection == null) {
                MoveToConstructorFix.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        private static Collection<PsiMethod> removeChainedConstructors(@NotNull Collection<PsiMethod> constructors2) {
            if (constructors2 == null) {
                MoveToConstructorFix.$$$reportNull$$$0(3);
            }
            Iterator<PsiMethod> iterator2 = constructors2.iterator();
            while (iterator2.hasNext()) {
                PsiMethod constructor = iterator2.next();
                if (JavaHighlightUtil.getChainedConstructors(constructor) == null) continue;
                iterator2.remove();
            }
            Collection<PsiMethod> collection = constructors2;
            if (collection == null) {
                MoveToConstructorFix.$$$reportNull$$$0(4);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/ClassInitializerInspection$MoveToConstructorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/ClassInitializerInspection$MoveToConstructorFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateConstructors";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeChainedConstructors";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateConstructors";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChainedConstructors";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

